% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_list.R
\name{rename_dl}
\alias{rename_dl}
\title{Rename features in a data list}
\usage{
rename_dl(dl, name_mapping)
}
\arguments{
\item{dl}{A nested list of input data from \code{data_list()}.}

\item{name_mapping}{A named vector where the values are the features to be
renamed and the names are the new names for those features.}
}
\value{
A data list ("list"-class object) with adjusted feature names.
}
\description{
Rename features in a data list
}
\examples{
dl <- data_list(
    list(pubertal, "pubertal_status", "demographics", "continuous"),
    list(anxiety, "anxiety", "behaviour", "ordinal"),
    list(depress, "depressed", "behaviour", "ordinal"),
    uid = "unique_id"
)

summary(dl, "feature")

name_changes <- c(
    "anxiety_score" = "cbcl_anxiety_r",
    "depression_score" = "cbcl_depress_r"
)

dl <- rename_dl(dl, name_changes)

summary(dl, "feature")
}
