% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/supp.R
\name{make_supp_qual}
\alias{make_supp_qual}
\title{Make Supplemental Qualifier}
\usage{
make_supp_qual(dataset, metacore, dataset_name = NULL)
}
\arguments{
\item{dataset}{dataset the supp will be pulled from}

\item{metacore}{A subsetted metacore object to get the supp information from.
If not already subsetted then a `dataset_name` will need to be provided}

\item{dataset_name}{optional name of dataset}
}
\value{
a CDISC formatted SUPP dataset
}
\description{
Make Supplemental Qualifier
}
\examples{

library(metacore)
library(safetyData)
library(tibble)
load(metacore_example("pilot_SDTM.rda"))
spec <- metacore \%>\% select_dataset("AE")
ae <- combine_supp(sdtm_ae, sdtm_suppae)
make_supp_qual(ae, spec) \%>\% as_tibble()
}
