% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codelists.R
\name{create_cat_var}
\alias{create_cat_var}
\title{Create Categorical Variable from Codelist}
\usage{
create_cat_var(data, metacore, ref_var, grp_var, num_grp_var = NULL)
}
\arguments{
\item{data}{Dataset with reference variable in it}

\item{metacore}{A metacore object to get the codelist from. If the
variable has different codelists for different datasets the metacore object
will need to be subsetted using `select_dataset` from the metacore package.}

\item{ref_var}{Name of variable to be used as the reference i.e AGE when
creating AGEGR1}

\item{grp_var}{Name of the new grouped variable}

\item{num_grp_var}{Name of the new numeric decode for the grouped variable.
This is optional if no value given no variable will be created}
}
\value{
dataset with new column added
}
\description{
Using the grouping from either the `decode_var` or `code_var` and a reference
variable (`ref_var`) it will create a categorical variable and the numeric
version of that categorical variable.
}
\examples{
library(metacore)
library(haven)
library(dplyr)
load(metacore_example("pilot_ADaM.rda"))
spec <- metacore \%>\% select_dataset("ADSL")
dm <- read_xpt(metatools_example("dm.xpt")) \%>\%
  select(USUBJID, AGE)
# Grouping Column Only
create_cat_var(dm, spec, AGE, AGEGR1)
# Grouping Column and Numeric Decode
create_cat_var(dm, spec, AGE, AGEGR1, AGEGR1N)
}
