% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summaries.R
\name{summaries}
\alias{summaries}
\title{Return summary statistics from a data frame of randomized metric values}
\usage{
summaries(null.output, concat.by = "richness")
}
\arguments{
\item{null.output}{Data frame of randomized metric values such as an element from a
call to reduceRandomizations()}

\item{concat.by}{Whether to concatenate the randomizations by richness, plot or both}
}
\value{
Either a list of or a data frame of summarized metric scores, see details.
}
\description{
Summarizes observed metric scores. Returns the mean, standard deviation and 
95\% confidence intervals of each plot or observed richness.
}
\details{
Given a data frame of metric values, summarizes either by plot or richness.
Outputs the mean, standard deviation and 95\% confidence intervals of each plot or
observed richness. If provided with concat.by="both", outputs a list of two data
frames, one for by richness and one for by plot. Otherwise, outputs a data frame.
Importantly, note that this function assumes that the first metric is species richness.
This applies even if the user does not wish to summarize by "richness" or by "both".
This is a design flaw and will be rectified in future versions of the package. For now,
see the examples for the correct way to specify that the first metric is indeed
"richness".
}
\examples{
#simulate tree with birth-death process
tree <- geiger::sim.bdtree(b=0.1, d=0, stop="taxa", n=50)

sim.abundances <- round(rlnorm(5000, meanlog=2, sdlog=1)) + 1

cdm <- simulateComm(tree, richness.vector=10:25, abundances=sim.abundances)

#run the metrics and nulls combo function
rawResults <- metricsNnulls(tree=tree, picante.cdm=cdm, randomizations=2, cores="seq",
nulls=c("richness","frequency"), metrics=c("richness","NAW_MPD"))

#summarize the results
results <- reduceRandomizations(rawResults)

test <- summaries(results$frequency, concat.by="richness")
}
\references{
Miller, E. T., D. R. Farine, and C. H. Trisos. 2016. Phylogenetic community
structure metrics and null models: a review with new methods and software.
Ecography DOI: 10.1111/ecog.02070
}

