% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RSE.R
\name{RSE}
\alias{RSE}
\title{Relative Squared Error (RSE)}
\usage{
RSE(data = NULL, obs, pred, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric}.
}
\description{
It estimates the RSE for a continuous predicted-observer dataset.
}
\details{
The RSE is the ratio between the residual sum of squares (RSS, error of
predictions with respect to observations) and the total sum of squares (TSS,
error of observations with respect to its mean). RSE is dimensionless, so it can be
used to compared models with different units.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
RSE(obs = X, pred = Y)
}
}
