% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_RMLP.R
\name{RMLP}
\alias{RMLP}
\title{Root Mean Lack of Precision (RMLP)}
\usage{
RMLP(data = NULL, obs, pred, tidy = FALSE, na.rm = TRUE)
}
\arguments{
\item{data}{(Optional) argument to call an existing data frame containing the data.}

\item{obs}{Vector with observed values (numeric).}

\item{pred}{Vector with predicted values (numeric).}

\item{tidy}{Logical operator (TRUE/FALSE) to decide the type of return. TRUE
returns a data.frame, FALSE returns a list; Default : FALSE.}

\item{na.rm}{Logic argument to remove rows with missing values
(NA). Default is na.rm = TRUE.}
}
\value{
an object of class \code{numeric} within a \code{list} (if tidy = FALSE) or within a
\verb{data frame} (if tidy = TRUE).
}
\description{
It estimates the RMLP, the square root of the unsystematic error
component to the Mean Squared Error (MSE), for a continuous predicted-observed
dataset following Correndo et al. (2021).
}
\details{
The RMLP represents the unsystematic (random) component of the MSE
expressed on the original variables units \eqn{ \sqrt{MLP} }.
It is obtained via a symmetric decomposition of the MSE (invariant to
predicted-observed orientation) using a symmetric regression line (SMA).
The RMLP is equal to the square-root of the sum of unsystematic differences
divided by the sample size (n). The greater the value the greater the random
noise of the predictions.
For the formula and more details, see \href{https://adriancorrendo.github.io/metrica/articles/available_metrics_regression.html}{online-documentation}
}
\examples{
\donttest{
set.seed(1)
X <- rnorm(n = 100, mean = 0, sd = 10)
Y <- X + rnorm(n=100, mean = 0, sd = 3)
RMLP(obs = X, pred = Y)
}
}
\references{
Correndo et al. (2021).
Revisiting linear regression to test agreement in continuous predicted-observed datasets.
\emph{Agric. Syst. 192, 103194.} \doi{10.1016/j.agsy.2021.103194}
}
