% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/metricsgraphics.R
\name{mjs_add_legend}
\alias{mjs_add_legend}
\title{Adds a legend to a metricsgraphics chart}
\usage{
mjs_add_legend(mjs, legend, inline = FALSE)
}
\arguments{
\item{mjs}{plot object}

\item{legend}{character vector of labels for the legend}

\item{inline}{\code{TRUE} if you want line labes to the right of the chart
vs in a legend block (experimental)}
}
\value{
metricsgraphics object
}
\description{
Adds a legend to a metricsgraphics chart
}
\examples{
set.seed(1492)
stocks <- data.frame(
  time = as.Date('2009-01-01') + 0:9,
  X = rnorm(10, 0, 1),
  Y = rnorm(10, 0, 2),
  Z = rnorm(10, 0, 4))

stocks \%>\%
  mjs_plot(x=time, y=X) \%>\%
  mjs_line() \%>\%
  mjs_add_line(Y) \%>\%
  mjs_add_line(Z) \%>\%
  mjs_axis_x(xax_format="date") \%>\%
  mjs_add_legend(legend=c("X", "Y", "Z"))
}

