% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mle.R
\name{fit.gpd}
\alias{fit.gpd}
\title{Maximum likelihood estimation for the generalized Pareto distribution}
\usage{
fit.gpd(xdat, threshold = 0, method = "Grimshaw", show = FALSE,
  MCMC = NULL, k = 4, tol = 1e-08)
}
\arguments{
\item{xdat}{a numeric vector of data to be fitted.}

\item{threshold}{the chosen threshold.}

\item{method}{the method to be used. See \bold{Details}. Can be abbreviated.}

\item{show}{logical; if \code{TRUE} (the default), print details of the fit.}

\item{MCMC}{\code{NULL} for frequentist estimates, otherwise a boolean or a list with parameters passed. If \code{TRUE}, runs a Metropolis-Hastings sampler to get posterior mean estimates. Can be used to pass arguments \code{niter}, \code{burnin} and \code{thin} to the sampler as a list.}

\item{k}{bound on the influence function (\code{method = "obre"}); the constant \code{k} is a robustness parameter
(higher bounds are more efficient, low bounds are more robust). Default to 4, must be larger than \eqn{\sqrt{2}}.}

\item{tol}{numerical tolerance for OBRE weights iterations (\code{method = "obre"}). Default to \code{1e-8}.}
}
\value{
If \code{method} is neither \code{'zs'} nor \code{'zhang'}, a list containing the following components:
\itemize{
\item \code{estimate} a vector containing the \code{scale} and \code{shape} parameters (optimized and fixed).
\item \code{std.err} a vector containing the standard errors. For \code{method = "obre"}, these are Huber's robust standard errors.
\item \code{vcov} the variance covariance matrix, obtained as the numerical inverse of the observed information matrix. For \code{method = "obre"},
this is the sandwich Godambe matrix inverse.
\item \code{threshold} the threshold.
\item \code{method} the method used to fit the parameter. See details.
\item \code{nllh} the negative log-likelihood evaluated at the parameter \code{estimate}.
\item \code{nat} number of points lying above the threshold.
\item \code{pat} proportion of points lying above the threshold.
\item \code{convergence} components taken from the list returned by \code{\link[stats]{optim}}.
Values other than \code{0} indicate that the algorithm likely did not converge (in particular 1 and 50).
\item \code{counts} components taken from the list returned by \code{\link[stats]{optim}}.
\item \code{exceedances} excess over the threshold.
}
Additionally, if \code{method = "obre"}, a vector of OBRE \code{weights}.

Otherwise, a list containing
\itemize{
\item \code{threshold} the threshold.
\item \code{method} the method used to fit the parameter. See \bold{Details}.
\item \code{nat} number of points lying above the threshold.
\item \code{pat} proportion of points lying above the threshold.
\item \code{approx.mean} a vector containing containing the approximate posterior mean estimates.
}
and in addition if MCMC is neither \code{FALSE}, nor \code{NULL}
\itemize{
\item \code{post.mean} a vector containing the posterior mean estimates.
\item \code{post.se} a vector containing the posterior standard error estimates.
\item \code{accept.rate} proportion of points lying above the threshold.
\item \code{niter} length of resulting Markov Chain
\item \code{burnin} amount of discarded iterations at start, capped at 10000.
\item \code{thin} thinning integer parameter describing
}
}
\description{
Numerical optimization of the generalized Pareto distribution for
data exceeding \code{threshold}.
This function returns an object of class \code{mev_gpd}, with default methods for printing and quantile-quantile plots.
}
\details{
The default method is \code{'Grimshaw'}, which maximizes the profile likelihood for the ratio scale/shape.  Other options include \code{'obre'} for optimal \eqn{B}-robust estimator of the parameter of Dupuis (1998), vanilla maximization of the log-likelihood using constrained optimization routine \code{'auglag'}, 1-dimensional optimization of the profile likelihood using \code{\link[stats]{nlm}} and \code{\link[stats]{optim}}. Method \code{'ismev'} performs the two-dimensional optimization routine \code{\link[ismev]{gpd.fit}} from the \code{\link[ismev]{ismev}} library, with in addition the algebraic gradient.
The approximate Bayesian methods (\code{'zs'} and \code{'zhang'}) are extracted respectively from Zhang and Stephens (2009) and Zhang (2010) and consists of a approximate posterior mean calculated via importance
sampling assuming a GPD prior is placed on the parameter of the profile likelihood.
}
\note{
Some of the internal functions (which are hidden from the user) allow for modelling of the parameters using covariates. This is not currently implemented within \code{gp.fit}, but users can call internal functions should they wish to use these features.
}
\examples{
data(eskrain)
fit.gpd(eskrain, threshold = 35, method = 'Grimshaw', show = TRUE)
fit.gpd(eskrain, threshold = 30, method = 'zs', show = TRUE)
}
\references{
Davison, A.C. (1984). Modelling excesses over high thresholds, with an application, in
\emph{Statistical extremes and applications}, J. Tiago de Oliveira (editor), D. Reidel Publishing Co., 461--482.

Grimshaw, S.D. (1993). Computing Maximum Likelihood Estimates for the Generalized
 Pareto Distribution, \emph{Technometrics}, \bold{35}(2), 185--191.

Northrop, P.J. and C. L. Coleman (2014). Improved threshold diagnostic plots for extreme value
analyses, \emph{Extremes}, \bold{17}(2), 289--303.

Zhang, J. (2010). Improving on estimation for the generalized Pareto distribution, \emph{Technometrics} \bold{52}(3), 335--339.

Zhang, J.  and M. A. Stephens (2009). A new and efficient estimation method for the generalized Pareto distribution.
\emph{Technometrics} \bold{51}(3), 316--325.

Dupuis, D.J. (1998). Exceedances over High Thresholds: A Guide to Threshold Selection,
\emph{Extremes}, \bold{1}(3), 251--261.
}
\seealso{
\code{\link[evd]{fpot}} and \code{\link[ismev]{gpd.fit}}
}
\author{
Scott D. Grimshaw for the \code{Grimshaw} option. Paul J. Northrop and Claire L. Coleman for the methods \code{nlm}, \code{nlm} and \code{ismev}.
J. Zhang and Michael A. Stephens (2009) and Zhang (2010) for the \code{zs} and \code{zhang} approximate methods and L. Belzile for methods \code{auglag} and \code{obre}, the wrapper and MCMC samplers.

If \code{show = TRUE}, the optimal \eqn{B} robust estimated weights for the largest observations are printed alongside with the
\eqn{p}-value of the latter, obtained from the empirical distribution of the weights. This diagnostic can be used to guide threshold selection:
small weights for the \eqn{r}-largest order statistics indicate that the robust fit is driven by the lower tail
and that the threshold should perhaps be increased.
}
