% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/profile.R
\name{gev.tem}
\alias{gev.tem}
\title{Tangent exponential model approximation for the GEV distribution}
\usage{
gev.tem(
  param = c("loc", "scale", "shape", "quant", "Nmean", "Nquant"),
  dat,
  psi = NULL,
  p = NULL,
  q = 0.5,
  N = NULL,
  n.psi = 50,
  plot = TRUE,
  correction = TRUE
)
}
\arguments{
\item{param}{parameter over which to profile}

\item{dat}{sample vector for the GEV distribution}

\item{psi}{scalar or ordered vector of values for the interest parameter. If \code{NULL} (default), a grid of values centered at the MLE is selected}

\item{p}{tail probability for the (1-p)th quantile (return levels). Required only if \code{param = 'retlev'}}

\item{q}{probability level of quantile. Required only for \code{param} \code{Nquant}.}

\item{N}{size of block over which to take maxima. Required only for \code{param} \code{Nmean} and \code{Nquant}.}

\item{n.psi}{number of values of \code{psi} at which the likelihood is computed, if \code{psi} is not supplied (\code{NULL}). Odd values are more prone to give rise to numerical instabilities near the MLE. If \code{psi} is a vector of length 2 and \code{n.psi} is greater than 2, these are taken to be endpoints of the sequence.}

\item{plot}{logical indicating whether \code{plot.fr} should be called upon exit}

\item{correction}{logical indicating whether \link{spline.corr} should be called.}
}
\value{
an invisible object of class \code{fr} (see \code{tem} in package \code{hoa}) with elements
\itemize{
\item{\code{normal}: }{maximum likelihood estimate and standard error of the interest parameter \eqn{psi}}
\item{\code{par.hat}: }{maximum likelihood estimates}
\item{\code{par.hat.se}: }{standard errors of maximum likelihood estimates}
\item{\code{th.rest}: }{estimated maximum profile likelihood at (\eqn{psi}, \eqn{\hat{\lambda}})}
\item{\code{r}: }{values of likelihood root corresponding to \eqn{\psi}}
\item{\code{psi}: }{vector of interest parameter}
\item{\code{q}: }{vector of likelihood modifications}
\item{\code{rstar}: }{modified likelihood root vector}
\item{\code{rstar.old}: }{uncorrected modified likelihood root vector}
\item{\code{param}: }{parameter}
}
}
\description{
The function \code{gev.tem} provides a tangent exponential model (TEM) approximation
for higher order likelihood inference for a scalar parameter for the generalized extreme value distribution.
Options include location scale and shape parameters as well as value-at-risk (or return levels).
The function attempts to find good values for \code{psi} that will
cover the range of options, but the fail may fit and return an error.
}
\examples{
\dontrun{
set.seed(1234)
dat <- rgev(n = 40, loc = 0, scale = 2, shape = -0.1)
gev.tem('shape', dat = dat, plot = TRUE)
gev.tem('quant', dat = dat, p = 0.01, plot = TRUE)
gev.tem('scale', psi = seq(1, 4, by = 0.1), dat = dat, plot = TRUE)
dat <- rgev(n = 40, loc = 0, scale = 2, shape = 0.2)
gev.tem('loc', dat = dat, plot = TRUE)
gev.tem('Nmean', dat = dat, p = 0.01, N=100, plot = TRUE)
gev.tem('Nquant', dat = dat, q = 0.5, N=100, plot = TRUE)
}
}
\author{
Leo Belzile
}
