% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bias.R
\name{gev}
\alias{gev}
\title{Generalized extreme value distribution}
\arguments{
\item{par}{vector of \code{loc}, \code{scale} and \code{shape}}

\item{dat}{sample vector}

\item{method}{string indicating whether to use the expected  (\code{"exp"}) or the observed (\code{"obs"} - the default) information matrix.}

\item{V}{vector calculated by \code{gev.Vfun}}

\item{n}{sample size}

\item{p}{vector of probabilities}
}
\description{
Likelihood, score function and information matrix, bias,
approximate ancillary statistics and sample space derivative
for the generalized extreme value distribution
}
\section{Usage}{
 \preformatted{gev.ll(par, dat)
gev.ll.optim(par, dat)
gev.score(par, dat)
gev.infomat(par, dat, method = c("obs","exp"))
gev.retlev(par, p)
gev.bias(par, n)
gev.Fscore(par, dat, method=c("obs","exp"))
gev.Vfun(par, dat)
gev.phi(par, dat, V)
gev.dphi(par, dat, V)}
}

\section{Note}{

The Gumbel case is not currently handled.
}

\section{Functions}{

\itemize{
\item{\code{gev.ll}:} {log-likelihood}
\item{\code{gev.ll.optim}:} {negative log-likelihood parametrized in terms of location, \code{log(scale)} and shape
in order to perform unconstrained optimization}
\item{\code{gev.score}:} {score vector}
\item{\code{gev.infomat}:} {observed or expected information matrix}
\item{\code{gev.retlev}:} {return level, corresponding to the \eqn{(1-p)}th quantile}
\item{\code{gev.bias}:} {Cox-Snell first order bias}
\item{\code{gev.Fscore}:} {Firth's modified score equation}
\item{\code{gev.Vfun}:} {vector implementing conditioning on approximate ancillary statistics for the TEM}
\item{\code{gev.phi}:} {canonical parameter in the local exponential family approximation}
\item{\code{gev.dphi}:} {derivative matrix of the canonical parameter in the local exponential family approximation}
}
}
\references{
Firth, D. (1993). Bias reduction of maximum likelihood estimates, \emph{Biometrika}, \strong{80}(1), 27--38.

Coles, S. (2001). \emph{An Introduction to Statistical Modeling of Extreme Values}, Springer, 209 p.

Cox, D. R. and E. J. Snell (1968). A general definition of residuals, \emph{Journal of the Royal Statistical Society: Series B (Methodological)}, \strong{30}, 248--275.

Cordeiro, G. M. and R. Klein (1994). Bias correction in ARMA models, \emph{Statistics and Probability Letters}, \strong{19}(3), 169--176.
}

