% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tailindex.R
\name{qweissman}
\alias{qweissman}
\title{Weissman's quantile estimator}
\usage{
qweissman(p, k, n, thresh, shape)
}
\arguments{
\item{p}{tail probability, must be larger than the proportion of exceedances \code{k/n}.}

\item{k}{vector of the number of exceedances above \code{thresh}}

\item{n}{integer, total sample size}

\item{thresh}{vector of thresholds}

\item{shape}{vector of positive shape parameters}
}
\value{
a vector of tail quantiles
}
\description{
Given a small probability of exceedance \code{p},
the number of exceedances \code{k} out of \code{n} observation
above the threshold \eqn{u} (\code{thresh}) (corresponding typically to the (\eqn{k+1})th order statistic, compute the tail quantile at level \eqn{Q(1-p)} using the estimator of Weissman (1978) under the assumption of Pareto tail (positive shape \eqn{\xi}), viz.
\deqn{ Q(1-p) = u \left(\frac{k}{pn}\right)^{\xi}.}
}
\examples{
set.seed(2025)
p <- 1/100
xdat <- rgp(n = 1000, loc = 2, scale = 2, shape = 0.4)
hill <- shape.hill(xdat, k = seq(20L, 100L, by = 10L))
thresh <- sort(xdat, decreasing = TRUE)[hill$k+1]
qweissman(
   p = 1/100,
   k = hill$k,
   n = length(xdat),
   thresh = thresh,
   shape = hill$shape)
# Compare with true quantile
qgp(1/100, loc = 2, scale = 2, shape = 0.4, lower.tail = FALSE)
}
\references{
Weissman, I. (1978). Estimation of Parameters and Larger Quantiles Based on the \emph{k} Largest Observations. \emph{Journal of the American Statistical Association}, 73(\bold{364}), 812–815. <doi:10.2307/2286285>.
}
