% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mevr.R
\name{fsmev}
\alias{fsmev}
\title{Fitting the simplified Metastatistical Extreme Value Distribution (SMEV)}
\usage{
fsmev(
  data,
  threshold = 0,
  method = c("pwm", "mle", "ls"),
  sd = FALSE,
  sd.method = "boot",
  R = 502
)
}
\arguments{
\item{data}{The data to which the SMEV should be fitted to. \code{data} must be a data.frame with two columns. 
The first column must contain dates of class \code{Date}, the second or last column must contain the rainfall 
values corresponding to datums in the rows. No NA or negative values are allowed.}

\item{threshold}{A numeric that is used to define wet days as values > threshold. 
\eqn{data <= threshold} is set to NA.}

\item{method}{Character string describing the method that is used to estimate the 
Weibull parameters c and w. Possible options are probability weighted moments (\code{method='pwm'}), 
maximum likelihood (\code{method='mle'}) or least squares (\code{method='ls'}). 
The \code{default} is \code{pwm}. (see details).}

\item{sd}{If \code{sd=TRUE}, confidence intervals of the SMEV distribution are calculated (see details).}

\item{sd.method}{Currently only a non parametric bootstrap technique can be used to calculate SMEV confidence intervals with \code{sd.method='boot'}. The default is \code{sd=FALSE}.}

\item{R}{The number of samples drawn from the SMEV distribution to calculate the confidence intervals with \code{sd.method='boot'}}
}
\value{
A list of class \code{mevr} with components:
\item{c}{ Single value of the Weibull scale parameter of the SMEV.}
\item{w}{ Single value of the Weibull shape parameter of the SMEV.}
\item{n}{ Mean number of wet events, averaged over all years. Wet events are defined as rainfall > \code{threshold}.}
\item{params}{ A named vector of the fitted parameters. }
\item{maxima}{ Maximum values corresponding to each year.}
\item{std}{ Standard error of fitted parameters (if \code{sd=TRUE}).}
\item{varcov}{ Covariance matrix of fitted parameters (if \code{sd=TRUE}).}
\item{data}{ \eqn{data >= threshold} used to fit the SMEV and additional components which may be useful for further analysis.}
\item{years}{ Vector of years as YYYY.}
\item{threshold}{ The chosen threshold.}
\item{method}{ Method used to fit the MEVD.}
\item{type}{ The type of distribution ("SMEV")}
}
\description{
Fit the SMEV distribution to rainfall observations with different estimation methods.
}
\details{
The SMEV was introduced by (Marra et al., 2019) as a simplified version of the MEVD 
(Marani and Ignaccolo, 2015) with the assumption of a stationary parent Weibull distribution 
as 
\deqn{F = [1 - exp(-x/C)^w]^n}
for \eqn{w > 0} and \eqn{C > 0} being the Weibull shape and scale parameter and 
\eqn{n > 0} being the mean number of wet days over all years. 
Wet days are defined as rainfall events > threshold. As it was shown by 
e.g. Schellander et al., 2019, probability weighted moments should be preferred over 
maximum likelihood for the estimation of the Weibull parameters w and C. Therefore 
\code{method = 'pwm'} is the default.

Confidence intervals of the SMEV distribution can be calculated using a non parametric 
bootstrap technique. Note that this very slow. 

This function returns the parameters of the fitted SMEV distribution as well as some 
additional fitting results and input parameters useful for further analysis.
}
\examples{
data(dailyrainfall)

fit <- fsmev(dailyrainfall)
fit
plot(fit)

}
\references{
Marra, F. et al. (2019) 'A simplified MEV formulation to model extremes emerging from multiple nonstationary underlying processes', Advances in Water Resources. Elsevier Ltd, 127(April), pp. 280-290. doi: 10.1016/j.advwatres.2019.04.002.
}
\seealso{
\code{\link{fmev}}, \code{\link{ftmev}}
}
\author{
Harald Schellander, Alexander Lieb
}
