% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interface.R
\name{predict.mfbvar}
\alias{predict.mfbvar}
\title{Predict method for class \code{mfbvar}}
\usage{
\method{predict}{mfbvar}(object, pred_quantiles = c(0.1, 0.5, 0.9),
  tidy = FALSE, ...)
}
\arguments{
\item{object}{object of class mfbvar}

\item{pred_quantiles}{The quantiles of the posterior predictive distribution to use.}

\item{tidy}{If results should be tidy or not.}

\item{...}{Currently not in use.}
}
\description{
Method for predicting \code{mfbvar} objects.
}
\details{
Note that this requires that forecasts were made in the original \code{mfbvar} call.
}
\examples{
prior_obj <- set_prior(Y = mf_sweden[, 4:5], freq = c("m", "q"),
                       n_lags = 4, n_burnin = 20, n_reps = 20, n_fcst = 4)
mod_minn <- estimate_mfbvar(prior_obj, prior_type = "minn")
predict(mod_minn)
predict(mod_minn, pred_quantiles = 0.5, tidy = TRUE)
}
