% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/concept.R
\name{concept}
\alias{concept}
\alias{concept.default}
\alias{concept.formula}
\title{Concept Meta-features}
\usage{
concept(...)

\method{concept}{default}(
  x,
  y,
  features = "all",
  summary = c("mean", "sd"),
  transform = TRUE,
  ...
)

\method{concept}{formula}(
  formula,
  data,
  features = "all",
  summary = c("mean", "sd"),
  transform = TRUE,
  ...
)
}
\arguments{
\item{...}{Further arguments passed to the summarization functions.}

\item{x}{A data.frame contained only the input attributes.}

\item{y}{A factor response vector with one label for each row/component of x.}

\item{features}{A list of features names or \code{"all"} to include all them.}

\item{summary}{A list of summarization functions or empty for all values. See
\link{post.processing} method to more information. (Default: 
\code{c("mean", "sd")})}

\item{transform}{A logical value indicating if the categorical attributes
should be transformed. If \code{FALSE} they will be ignored. (Default: 
\code{TRUE})}

\item{formula}{A formula to define the class column.}

\item{data}{A data.frame dataset contained the input attributes and class.
The details section describes the valid values for this group.}
}
\value{
A list named by the requested meta-features.
}
\description{
Concept characterization features measure the sparsity of the input space and 
the irregularity of the input-output distribution measures extract 
information about validation index.
}
\details{
The following features are allowed for this method:
 \describe{
   \item{"cohesiveness"}{Example Cohesiveness is a different version of the
     wgDist measure.}
   \item{"conceptvar"}{Concept variation estimates the variability of class 
     labels among examples.}
   \item{"impconceptvar"}{Improved concept variation is a different version
      of the conceptvar measure.}
   \item{"wgDist"}{Weighted distance captures how dense or sparse is the 
     example distribution.}
 }
}
\examples{
## Extract all meta-features using formula
concept(Species ~ ., iris)

## Extract some meta-features
concept(iris[1:4], iris[5], c("conceptvar"))

## Use another summarization function
concept(Species ~ ., iris, summary=c("min", "median", "max"))
}
\references{
Vilalta, R., & Drissi, Y. (2002). A characterization of difficult 
 problems in classification. In M. A. Wani, H. R. Arabnia, K. J. 
 Cios, K. Hafeez, G. Kendall (Eds.), Proceedings ofthe 2002 
 international conference on machine learning and applications - 
 ICMLA 2002, June 24-27, 2002, Las Vegas, Nevada (pp. 133-138).
 
Vilalta, R., 1999. Understanding accuracy performance through 
 concept characterization and algorithm analysis. In: ECML 
 Workshop on Recent Advances in Meta-Learning and Future Work. 
 pp. 3-9.
}
\seealso{
Other meta-features: 
\code{\link{clustering}()},
\code{\link{complexity}()},
\code{\link{general}()},
\code{\link{infotheo}()},
\code{\link{itemset}()},
\code{\link{landmarking}()},
\code{\link{model.based}()},
\code{\link{relative}()},
\code{\link{statistical}()}
}
\concept{meta-features}
