% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplotly_plotSmooth.R
\name{ggplotly.plotSmooth}
\alias{ggplotly.plotSmooth}
\title{Convert plotSmooth objects to plotly}
\usage{
ggplotly.plotSmooth(p, ...)
}
\arguments{
\item{p}{an object of class \code{plotSmooth}.}

\item{...}{extra arguments passed to \link[plotly:ggplotly]{plotly::ggplotly}.}
}
\description{
Given an object of class \code{plotSmooth}, this function
extract a \code{ggplot} object and use it a
}
\examples{
\dontrun{
library(mgcViz)
n  <- 1e3
x1 <- rnorm(n)
x2 <- rnorm(n)
dat <- data.frame("x1" = x1, "x2" = x2,
                  "y" = sin(x1) + 0.5 * x2^2 + pmax(x2, 0.2) * rnorm(n))
b <- bam(y ~ s(x1)+s(x2), data = dat, method = "fREML", discrete = TRUE)
b <- getViz(b)

# Interactive plotly plot.
ggplotly.plotSmooth( plot( sm(b, 1) ) + l_points(colour = "grey") + 
                     l_fitLine() + l_ciLine() )
}
}
