% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L_dens2D.R
\name{l_dens2D}
\alias{l_dens2D}
\alias{l_dens}
\title{Adding density estimate heatmap}
\usage{
l_dens2D(type, n = c(50, 50), bw = NULL, tol = 1e-06, trans = sqrt,
  ...)

l_dens(type, n = c(50, 50), bw = NULL, tol = 1e-06, trans = sqrt,
  ...)
}
\arguments{
\item{type}{for 1D effect plots, if set to "cond" then the conditional residual
density \code{p(r|x)} is plotted. If set to "joint" the
joint density of residuals, \code{p(r, x)}, is plotted.
The behaviour is similar for 2D effect plots, but \code{r} indicates
the second covariate, not the residuals.}

\item{n}{vector of two positive integers, indicating the number of grid points
at which the density is evaluated on the x and y axes.}

\item{bw}{vector with two positive entries, indicating the bandwidth to be used
by the kernel density estimator of \code{p(x1, x2)} along x1 and x2.}

\item{tol}{small positive numerical tolerance. The estimated density at a certain
location is set to \code{NA} (hence it will appear white) when it falls
below \code{tol/sqrt(2*pi*sig)}, where \code{sig} is the standard
deviation of the residuals. Set \code{tol} to -1 plot the density on
the whole x-y plane, no matter how low it is.}

\item{trans}{the density on x-y is transformed using this function before being plotted.}

\item{...}{graphical arguments to be passed to \code{ggplot2::geom_raster}.}
}
\value{
An object of class \code{gamLayer}.
}
\description{
This layer adds a 2D density estimate heat-map to a plot.
For 1D effect plots, it adds either the conditional density of the partial
residuals, \code{p(r|x)}, or the joint density \code{p(r, x)}. For 2D
effect plots it adds either \code{p(x1|x2)} or \code{p(x1, x2)}, where
\code{x1} and \code{x2} are the relevant covariates.
}
\details{
The density function is estimated using the fast binned kernel density estimation
methods provided by the \code{KernSmooth} package, hence this function should be
able to handle relatively large datasets (~ 10^6 observations).
}
\seealso{
See \link{plot.mgcv.smooth.1D}, \link{plot.mgcv.smooth.2D} and \link{check1D} for examples.
}
