% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamm4V.R, R/gammV.R
\name{gamm4V}
\alias{gamm4V}
\alias{gammV}
\title{Fit a GAMM or GAMM4 model and get a gamViz object}
\usage{
gamm4V(
  formula,
  random,
  family = gaussian(),
  data = list(),
  REML = TRUE,
  aGam = list(),
  aViz = list(),
  keepGAMObj = FALSE
)

gammV(
  formula,
  random,
  family = gaussian(),
  data = list(),
  method = "REML",
  aGam = list(),
  aViz = list(),
  keepGAMObj = FALSE
)
}
\arguments{
\item{formula, random, family, data}{same arguments as in \link[mgcv:gamm]{mgcv::gamm} or \link[gamm4:gamm4]{gamm4::gamm4}.}

\item{REML}{same as in \link[gamm4:gamm4]{gamm4::gamm4}}

\item{aGam}{list of further arguments to be passed to \link[mgcv:gamm]{mgcv::gamm} or \link[gamm4:gamm4]{gamm4::gamm4}.}

\item{aViz}{list of arguments to be passed to \link{getViz}.}

\item{keepGAMObj}{if \code{TRUE} a copy of the gamViz Object is kept under $gam to assure compatibility with \link[mgcv:gamm]{mgcv::gamm} and \link[gamm4:gamm4]{gamm4::gamm4}. Defaults to \code{FALSE}.}

\item{method}{same as in \link[mgcv:gamm]{mgcv::gamm}}
}
\value{
An object of class "gamViz" which can, for instance, be plotted using \link{plot.gamViz}. Also the object has the following additional elements:
\itemize{
\item \code{lme} mixed model as in \link[mgcv:gamm]{mgcv::gamm}
\item \code{mer} mixed model as in \link[gamm4:gamm4]{gamm4::gamm4}
\item \code{gam} a copy of the gamViz Object if setting \code{keepGAMObj = TRUE}.
}
}
\description{
These are wrappers that fit GAM models using \link[mgcv:gamm]{mgcv::gamm} or \link[gamm4:gamm4]{gamm4::gamm4} and
convert them to a \code{gamViz} object using the \link{getViz} function.
It is essentially a shortcut.
}
\details{
WARNING: Model comparisons (e.g. with \code{anova}) should only be done using the mixed model part as described in \link[gamm4:gamm4]{gamm4::gamm4}.
For \link[mgcv:gamm]{mgcv::gamm} please refer to the original help file.
}
\examples{
##### gam example
library(mgcViz)
# Simulate data
dat <- gamSim(1,n=400,scale=2) ## simulate 4 term additive truth
## Now add 20 level random effect `fac'...
dat$fac <- fac <- as.factor(sample(1:20,400,replace=TRUE))
dat$y <- dat$y + model.matrix(~fac-1) \%*\% rnorm(20) * 0.5

br <- gammV(y~s(x0)+x1+s(x2), data=dat,random=list(fac=~1))
summary(br)
plot(br)

summary(br$lme)

\dontrun{
## gamm4::gamm4 example
br4 <- gamm4V(y~s(x0)+x1+s(x2),data=dat,random=~(1|fac))
summary(br4)
plot(br4)

summary(br4$mer)
}

}
