% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDnase_function.R
\name{addDnase}
\alias{addDnase}
\title{Add data from Maurano et. al. Nat Genet. 2015 regarding allele specific DNAse hypersensitivty.}
\usage{
addDnase(mgl, range = 0, download = TRUE, saveDownload = FALSE,
  fpsource = "./")
}
\arguments{
\item{mgl}{List; see \code{\link{buildFromNames}}, \code{\link{buildFromRegion}}, or \code{\link{buildFromEnsgs}}}

\item{range}{Number indicating distance upstream of start and downstream of stop that should be used for filtering SNPs.}

\item{download}{A logical vector indicating if the data should be downloaded.}

\item{saveDownload}{A logical vector indicating if the data should be saved as 'RawData_Dnase.RData'}

\item{fpsource}{A character string of with the filepath where the data has been downloaded}
}
\description{
\code{addDnase} returns an 'mgl' list with the twelfth element as a dataframe containing results from Maurano et. al. Nat Genet. 2015
}
\details{
This gives the results for each gene, subsetting the data to reflect those SNPs that fall within the gene region.  Data was originally downloaded from \url{http://www.nature.com/ng/journal/v47/n12/extref/ng.3432-S5.txt}.
}
\section{Warning}{

All results will be added.  To view only SNPs with a significant imbalance use \code{\link{makeDnaseSig}}
}
\examples{
\dontrun{buildFromRegion(chr = 2, start = 102314000, stop = 103435000) -> myMgl}
\dontrun{myMgl <- addDnase(myMgl, range = 0)}

}
\seealso{
Other elements: \code{\link{addAei}},
  \code{\link{addAntisense}}, \code{\link{addCisEqtl}},
  \code{\link{addEnst}}, \code{\link{addExpression}},
  \code{\link{addGo}}, \code{\link{addGrasp}},
  \code{\link{addGwasCatalog}}, \code{\link{addLoc}},
  \code{\link{addPtv}}, \code{\link{addPubmed}},
  \code{\link{addSqtlAltrans}}, \code{\link{addSqtlSeek}},
  \code{\link{addTransEqtl}}, \code{\link{missNames}}
}

