% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npSurv2_plots.R
\name{plotnpSurv2.HM}
\alias{plotnpSurv2.HM}
\title{Uses a heat map to visualize a nonparametric bivariate survival function}
\usage{
plotnpSurv2.HM(
  npSurv2.obj,
  contour = TRUE,
  col = terrain.colors(100),
  xlab = "T1",
  ylab = "T2",
  ...
)
}
\arguments{
\item{npSurv2.obj}{Output of the npSurv2 function.}

\item{contour}{Should contour lines be added to the plot? Defaults to
TRUE.}

\item{col}{List of colors for the heat map. Defaults to
terrain.colors(100).}

\item{xlab}{The x-axis label. Defaults to "T1".}

\item{ylab}{The y-axis label. Defaults to "T2".}

\item{...}{Additional parameters to the image function.}
}
\description{
Plots a heat map of an estimated nonparametric bivariate survival
function. This function is a wrapper for the image function with default
parameters chosen to make the data easier to visualize.
}
\examples{
x <- genClayton2(1000, 0, 1, 1, 2, 2)
x.npSurv2 <- npSurv2(x$Y1, x$Y2, x$Delta1, x$Delta2)
plotnpSurv2.HM(x.npSurv2)

x2 <- genClayton2(1000, 2, 1, 1, 2, 2)
x2.npSurv2 <- npSurv2(x2$Y1, x2$Y2, x2$Delta1, x2$Delta2)
plotnpSurv2.HM(x2.npSurv2)
}
\seealso{
\code{\link{npSurv2}}, \code{\link[graphics]{image}}
}
