% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/milags_functions.R
\name{calc_lag_fit_to_logistic_with_lag}
\alias{calc_lag_fit_to_logistic_with_lag}
\title{calc_lag_fit_to_logistic_with_lag}
\usage{
calc_lag_fit_to_logistic_with_lag(
  gr_curve,
  n0,
  init_gr_rate = init_gr_rate,
  init_K = init_K,
  init_lag = init_lag,
  algorithm = "auto",
  max_iter = 100,
  lower_bound = c(0, 0, 0)
)
}
\arguments{
\item{gr_curve}{data from one specific growth curve with these two columns: time and biomass}

\item{n0}{the initial biomass}

\item{init_gr_rate}{initial value for the growth rate}

\item{init_K}{initial value for the saturation parameter K}

\item{init_lag}{initial value for the lag parameter}

\item{algorithm}{defaults to "auto" which chooses between bounded and unbounded Levenberg-Marquardt method and the bounded port method}

\item{max_iter}{max. number of iterations; defaults to 100}

\item{lower_bound}{lower bound for the bounded nls optimization; defaults to 0}
}
\value{
lag and the nls fitting object with parameters fitted to logistic model
}
\description{
Runs nlsLM/nls algorithm of the user's choice to fit the  Logistic model parameters to our data
}
