% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/self_made_topics.R
\name{plot_score_topic}
\alias{plot_score_topic}
\title{Plot frequency of self-chosen topic scores in abstracts}
\usage{
plot_score_topic(
  df,
  keywords,
  case = FALSE,
  name.topic = "TOPIC",
  bins = NULL,
  colour = "steelblue3",
  col.abstract = Abstract,
  col.pmid = PMID,
  title = NULL
)
}
\arguments{
\item{df}{Data frame containing abstracts.}

\item{keywords}{Character vector. Vector containing keywords. How much weight
a keyword in \code{keywords} carries is determined by how often it is present in
\code{keywords}, e.g. if a keyword is mentioned twice in \code{keywords} and it is mentioned only once in
an abstract, it adds 2 points to the score.}

\item{case}{Boolean. If \code{case = TRUE}, terms contained in \code{keywords} are case
sensitive. If \code{case = FALSE}, terms contained in \code{keywords} are case insensitive.}

\item{name.topic}{String. Name of the topic.}

\item{bins}{Integer. Specifies how many bins are used to plot
the distribution. If \code{bins = NULL}, bins are calculated over the whole
range of scores, with one bin per score.}

\item{colour}{String. Colour of histogram.}

\item{col.abstract}{Symbol. Column containing abstracts.}

\item{col.pmid}{Symbol. Column containing PubMed-IDs.}

\item{title}{String. Plot title.}
}
\value{
Histogram displaying the distribution of self-chosen topic scores in
abstracts.
}
\description{
Plot frequency of self-chosen topic scores in abstracts.
}
\details{
Plots a frequency distribution of self-chosen topic scores in abstracts of a
data frame. The topic score is influenced by the choice of
terms in \code{keywords}. Plotting the distribution can help in choosing the right
threshold to decide which abstracts correspond to the self-chosen
topic.
}
\seealso{
\code{\link[=calculate_score_topic]{calculate_score_topic()}}, \code{\link[=assign_topic]{assign_topic()}}

Other score functions: 
\code{\link{assign_topic}()},
\code{\link{calculate_score_animals}()},
\code{\link{calculate_score_biomarker}()},
\code{\link{calculate_score_patients}()},
\code{\link{calculate_score_topic}()},
\code{\link{plot_score_animals}()},
\code{\link{plot_score_biomarker}()},
\code{\link{plot_score_patients}()}
}
\concept{score functions}
