% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/target_mirna.R
\name{count_target}
\alias{count_target}
\title{Count targets in data frame}
\usage{
count_target(df, col.target = Target, add.df = TRUE)
}
\arguments{
\item{df}{Data frame containing a column with targets.}

\item{col.target}{Symbol. Column containing targets.}

\item{add.df}{Boolean. If \code{add.df = TRUE}, adds column \code{Target_count} to \code{df}
containing the count of targets. If \code{add.df = FALSE}, returns a new data frame
with the count of targets.}
}
\value{
Data frame, either with the targets and their frequency as a new
data frame,
or with the frequency of targets added as a
new column to the input data frame \code{df}.
}
\description{
Count occurrence of targets in  a data frame.
}
\details{
Count occurrence of targets in  a data frame. The count of targets
can either be returned as a separate data frame, only listing the targets
and their respective frequency, or it can be added to the
data frame provided as an extra column.
}
\seealso{
\code{\link[=join_targets]{join_targets()}}, \code{\link[=plot_target_count]{plot_target_count()}}

Other target functions: 
\code{\link{join_mirtarbase}()},
\code{\link{join_targets}()},
\code{\link{plot_target_count}()},
\code{\link{plot_target_mir_scatter}()}
}
\concept{target functions}
