% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.r
\name{as.mids}
\alias{as.mids}
\title{Converts an multiply imputed dataset (long format) into a \code{mids} object}
\usage{
as.mids(data, .imp = NA, .id = NA)
}
\arguments{
\item{data}{A multiply imputed data set in long format, for example 
produced by a call to \code{complete(..., action = 'long', include = TRUE)}.}

\item{.imp}{Optional column number in \code{data} that contains the imputation 
number. The number \code{0} indicates the original data (with missings) 
and \code{1} through \code{m} correspond to the \code{m} imputation number. 
If not specified, the function searches for a variable named \code{".imp"}.}

\item{.id}{Optional column number in \code{data} indicating the subject 
identification. If not specified, then the function searches for a variable 
named \code{.id} in \code{data}.}
}
\value{
An object of class \code{mids}
}
\description{
This function converts imputed data stored in long format into 
an object of class \code{mids}. The original incomplete dataset 
needs to be available so that we know where the missing data are.
The function is useful to convert back operations applied to 
the imputed data back in a \code{mids} object. It may also be 
used to store multiply imputed data sets from other software 
into the format used by \code{mice}.
}
\details{
If .id variable is found, row names from the supplied data will 
be copied to the \code{data} elements of the returned \code{mids} object.
}
\examples{
# impute the nhanes dataset
imp <- mice(nhanes, print = FALSE)
# extract the data in long format
X <- complete(imp, action = "long", include = TRUE)
# create dataset with .imp variable as numeric
X2 <- X
X2$.imp <- as.numeric(levels(X$.imp))[X$.imp]

# nhanes example without .id
test1 <- as.mids(X)
is.mids(test1)
all(complete(test1, action = "long", include = TRUE) == X, na.rm = TRUE)

# nhanes example without .id where .imp is numeric
test2 <- as.mids(X2)
is.mids(test2)
all(complete(test2, action = "long", include = TRUE) == X, na.rm = TRUE)

# nhanes example, where we explicitly specify .id as column 2
test3 <- as.mids(X, .id = 2)
is.mids(test3)
all(complete(test3, action = "long", include = TRUE) == X, na.rm = TRUE)

# nhanes example with .id where .imp is numeric
test4 <- as.mids(X2, .id = 2)
is.mids(test4)
all(complete(test4, action = "long", include = TRUE) == X, na.rm = TRUE)

# example without an .id variable
# variable .id not preserved
X3 <- X[, -2]
test5 <- as.mids(X3)
is.mids(test5)
all(complete(test5, action = "long", include = TRUE)[, -2] == X[, -2], na.rm = TRUE)

# 
}
\author{
Gerko Vink
}
\keyword{mids}
