% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mice.impute.sample.R
\name{mice.impute.sample}
\alias{mice.impute.sample}
\title{Imputation by simple random sampling}
\usage{
mice.impute.sample(y, ry, x = NULL, wy = NULL, ...)
}
\arguments{
\item{y}{Vector to be imputed}

\item{ry}{Logical vector of length \code{length(y)} indicating the 
the subset \code{y[ry]} of elements in \code{y} to which the imputation 
model is fitted. The \code{ry} generally distinguishes the observed 
(\code{TRUE}) and missing values (\code{FALSE}) in \code{y}.}

\item{x}{Numeric design matrix with \code{length(y)} rows with predictors for 
\code{y}. Matrix \code{x} may have no missing values.}

\item{wy}{Logical vector of length \code{length(y)}. A \code{TRUE} value 
indicates locations in \code{y} for which imputations are created.}

\item{...}{Other named arguments.}
}
\value{
Vector with imputed data, same type as \code{y}, and of length 
\code{sum(wy)}
}
\description{
Imputes a random sample from the observed \code{y} data
}
\details{
This function takes a simple random sample from the observed values in
\code{y}, and returns these as imputations.
}
\references{
van Buuren S and Groothuis-Oudshoorn K (2011). \code{mice}:
Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of
Statistical Software}, \bold{45}(3), 1-67.
\url{http://www.jstatsoft.org/v45/i03/}
}
\author{
Stef van Buuren, Karin Groothuis-Oudshoorn, 2000, 2017
}
\keyword{datagen}
