#' Multiply imputed data set (\code{mids})
#'
#' The \code{mids} object contains a multiply imputed data set. The \code{mids} object is
#' generated by functions \code{mice()}, \code{mice.mids()}, \code{cbind.mids()},
#' \code{rbind.mids()} and \code{ibind.mids()}.
#'
#' The \code{mids}
#' class of objects has methods for the following generic functions:
#' \code{print}, \code{summary}, \code{plot}.
#'
#' @section Slots:
#'  \describe{
#'    \item{\code{.Data}:}{Object of class \code{"list"} containing the
#'    following slots:}
#'    \item{\code{data}:}{Original (incomplete) data set.}
#'    \item{\code{imp}:}{A list of \code{ncol(data)} components with
#'    the generated multiple imputations. Each list components is a
#'    \code{data.frame} (\code{nmis[j]} by \code{m}) of imputed values
#'    for variable \code{j}.}
#'    \item{\code{m}:}{Number of imputations.}
#'    \item{\code{where}:}{The \code{where} argument of the
#'    \code{mice()} function.}
#'    \item{\code{blocks}:}{The \code{blocks} argument of the
#'    \code{mice()} function.}
#'    \item{\code{call}:}{Call that created the object.}
#'    \item{\code{nmis}:}{An array containing the number of missing
#'    observations per column.}
#'    \item{\code{method}:}{A vector of strings of \code{length(blocks}
#'    specifying the imputation method per block.}
#'    \item{\code{predictorMatrix}:}{A numerical matrix of containing
#'    integers specifying the predictor set.}
#'    \item{\code{visitSequence}:}{The sequence in which columns are visited.}
#'    \item{\code{formulas}:}{A named list of formula's, or expressions that
#'    can be converted into formula's by \code{as.formula}. List elements
#'    correspond to blocks. The block to which the list element applies is
#'    identified by its name, so list names must correspond to block names.}
#'    \item{\code{post}:}{A vector of strings of length \code{length(blocks)}
#'    with commands for post-processing.}
#'    \item{\code{blots}:}{"Block dots". The \code{blots} argument to the \code{mice()}
#'    function.}
#'    \item{\code{ignore}:}{A logical vector of length \code{nrow(data)} indicating
#'    the rows in \code{data} used to build the imputation model. (new in \code{mice 3.12.0})}
#'    \item{\code{seed}:}{The seed value of the solution.}
#'    \item{\code{iteration}:}{Last Gibbs sampling iteration number.}
#'    \item{\code{lastSeedValue}:}{The most recent seed value.}
#'    \item{\code{chainMean}:}{A list of \code{m} components. Each
#'    component is a \code{length(visitSequence)} by \code{maxit} matrix
#'    containing the mean of the generated multiple imputations.
#'    The array can be used for monitoring convergence.
#'    Note that observed data are not present in this mean.}
#'    \item{\code{chainVar}:}{A list with similar structure of \code{chainMean},
#'    containing the covariances of the imputed values.}
#'    \item{\code{loggedEvents}:}{A \code{data.frame} with five columns
#'    containing warnings, corrective actions, and other inside info.}
#'    \item{\code{version}:}{Version number of \code{mice} package that
#'    created the object.}
#'    \item{\code{date}:}{Date at which the object was created.}
#' }
#'
#' @details
#' The \code{loggedEvents} entry is a matrix with five columns containing a
#' record of automatic removal actions. It is \code{NULL} is no action was
#' made.  At initialization the program does the following three actions:
#' \describe{
#' \item{1}{A variable that contains missing values, that is not imputed
#' and that is used as a predictor is removed}
#' \item{2}{A constant variable is removed}
#' \item{3}{A collinear variable is removed.}
#' }
#' During iteration, the program does the following
#' actions:
#' \describe{
#' \item{1}{One or more variables that are linearly dependent are removed
#' (for categorical data, a 'variable' corresponds to a dummy variable)}
#' \item{2}{Proportional odds regression imputation that does not converge
#' and is replaced by \code{polyreg}.}
#' }
#'
#' Explanation of elements in \code{loggedEvents}:
#' \describe{
#' \item{\code{it}}{iteration number at which the record was added,}
#' \item{\code{im}}{imputation number,}
#' \item{\code{dep}}{name of the dependent variable,}
#' \item{\code{meth}}{imputation method used,}
#' \item{\code{out}}{a (possibly long) character vector with the
#' names of the altered or removed predictors.}
#' }
#'
#' @note The \code{mice} package does not use
#' the S4 class definitions, and instead relies on the S3 list
#' equivalent \code{oldClass(obj) <- "mids"}.
#'
#' @name mids-class
#' @rdname mids-class
#' @aliases mids-class mids
#' @author Stef van Buuren, Karin Groothuis-Oudshoorn, 2000
#' @seealso \code{\link{mice}}, \code{\link[=mira-class]{mira}},
#' \code{\link{mipo}}
#' @references van Buuren S and Groothuis-Oudshoorn K (2011). \code{mice}:
#' Multivariate Imputation by Chained Equations in \code{R}. \emph{Journal of
#' Statistical Software}, \bold{45}(3), 1-67.
#' \doi{10.18637/jss.v045.i03}
#' @keywords classes
NULL
