% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/microPopModel.R
\name{microPopModel}
\alias{microPopModel}
\title{microPopModel}
\usage{
microPopModel(microbeNames, times, resourceSysInfo, microbeSysInfo,
  rateFuncs = rateFuncsDefault, odeFunc = derivsDefault,
  numStrains = 1, oneStrainRandomParams = FALSE, pHLimit = FALSE,
  pHVal = NA, plotOptions = list(), odeOptions = list(),
  strainOptions = list(), checkingOptions = list(),
  microbeMolarMass = 113, bacCutOff = 1e-14)
}
\arguments{
\item{microbeNames}{Vector of strings which contains the names of the microbial groups in the system e.g. c('Bacteroides','Acetogens'). A dataframe for each of the same name must also exist in the workspace.}

\item{times}{Vector of times at which the solution is required, e.g. seq(0,10,0.1)}

\item{resourceSysInfo}{String giving the name of a csv file or a dataframe object, which describes the initial conditions, inflow and outflow (if constant) and molar mass of each resource. See help(resourceSysInfo) for more info.}

\item{microbeSysInfo}{String giving the name of a csv file (e.g. 'systemInfoMicrobes.csv') or a dataframe object, which describes the initial conditions, inflow and outflow (if constant) of each microbial group. See help(microbeSysInfo) for more info.}

\item{rateFuncs}{A list of functions which are used to solve the ODEs in odeFunc. Default is rateFuncsDefault.R (provided in the package). See ?rateFuncs}

\item{odeFunc}{The function the ODE solver will use - the default is derivsDefault provided by the package but if the user wants to make significant changes a new ODE function file can be used. See ?derivsDefault}

\item{numStrains}{Integer stating the number of strains in each microbial group (same for all groups). Default is 1.}

\item{oneStrainRandomParams}{Logical to allow randomization of parameters even if there is only one strain. The default is FALSE which means that if numStrains=1 then the group params are used; if numStrains>1 then the parameters are automatically randomised according to info given in strainOptions. If oneStrainRandomParams=TRUE then even if there is only one strain its parameters will be randomised according to info given in strainOptions.}

\item{pHLimit}{TRUE if pH limits microbial growth rates. Default is FALSE. If TRUE then rateFuncs$pHLimFunc is called.}

\item{pHVal}{Scalar. If the pH value is fixed it can be specified here and this is then used in the default rateFuncs$pHFunc function.}

\item{plotOptions}{List containing instructions for plotting: Default is list(plotFig=TRUE, sumOverStrains=FALSE, saveFig=FALSE, figType='eps', figName='microPopFig', yLabel='Concentration (g/L)', xLabel='Time').\cr
To turn off plot generation set plotFig=FALSE. If there are multiple strains these are all plotted if sumOverStrains=FALSE, otherwise they will be summed over each group. To save plot, saveFig=TRUE, figType (format) can be 'eps','png', 'pdf' or 'tiff' and is specified in figType (string), the name is figName (string) to which the string 'Microbes' or 'Resources' will be added for the respective plots.}

\item{odeOptions}{List containing instructions for the ODE solver ('deSolve'). Default: list('atol'=1e-6,'rtol'=1e-6,'method'='lsoda'). See ?ode for more details.}

\item{strainOptions}{List containing instructions for specifying strain parameters. Default: list(randomParams=c('halfSat', 'yield', 'maxGrowthRate', 'pHtrait'), seed=1, distribution='uniform', percentTraitRange=0, maxPHshift=0., applyTradeOffs=FALSE, tradeOffParams=NULL, paramsSpecified=FALSE, paramDataName=NULL). 
\itemize{
\item randomParams (vector) specifying which parameters need to be stochastically generated.
\item seed (number) seed for random number generator.
\item distribution (string) - either 'uniform' or 'normal' specifying the shape of the distribution from which to draw the random strain parameters. 
\item percentTraitRange (number) this is the percentage either side of the group parameter value which the strain parameter may range e.g. if percentTraitRange=10 then range is 0.9x to 1.1x for group mean x. 
\item maxPHshift (number) pH units to range over.
\item applyTradeOffs (logical) to trade off `good' and `bad' parameter values. 
\item tradeOffParams (vector of two strings) - parameters to trade off against each other. Note that pHtrait can not be traded off as whether this trait is good or bad depends on the environmental pH.
\item paramsSpecified (logical) TRUE if strain parameters are read in from a file (whose name is specified in paramDataName). The file must have colnames c(strainName, paramName, paramVal, paramUnit, resource,path) and where strainName is in format 'groupName.i' where i is the strain number.
}}

\item{checkingOptions}{(List) Default is list(checkMassConv=FALSE, balanceTol=1e-2, reBalanceStoichiom=FALSE, stoiTol=0.1, checkForNegs=TRUE, negTol=-1e-2). 
\itemize{
\item checkMassConv=TRUE checks for mass conservation in the ODE solver with a tolerance of 'balanceTol' (default is FALSE).
\item reBalanceStoichiom will check the mass balance of the stoichiometries on every metabolic path and rebalance if these are not conserving mass within a tolerance of stoiTol (a warning message will be issued). Rebalancing will only affect the final solution if the pathway contains only essential resources (Rtype 'Se') and microbial biomass is a product (Rtype 'Pb').  
\item checkForNegs If TRUE the function checkSolution is called and the solution for each variable, x, is checked for negative values that are greater in magnitude than negTol*max(x). If negative values occur then the solution is incorect and either the problem is incorrectly specified or the tolerances in the ODE solver need to be smaller.
}}

\item{microbeMolarMass}{Scalar. Mass of 1 mole of microbes - default is 113g/mol (Batstone et al., 2002)}

\item{bacCutOff}{Scalar. Amount of bacteria below which the bacteria are considered to have left the system and can't grow, default =1e-14. If this is set to zero then bacteria will always be able to grow again as zero is never reached.}
}
\value{
The output is a list containing a matrix called 'solution' where rows are points in time and the columns are the state variables, and another list called parms which contains all the information needed to run the model. Within parms there are a number of other lists (e.g. Pmats for parameter values and Smats for system settings etc - try names(out$parms)).
}
\description{
Runs the microbial population model
}
\examples{
#simplest example - define one microbial group (Archea) with 4 resources and
#simulate growth over 50 days
#make microbial group data frame:
MFG=matrix(NA,ncol=4,nrow=6,dimnames=list(c('Rtype','halfSat','yield',
'maxGrowthRate','stoichiom','keyResource'),c('H2','CO2','CH4','H2O')))
MFG['Rtype',]=c('Se','Se','P','P')
MFG['halfSat',c('H2','CO2')]=1e-6
MFG['yield','H2']=0.2
MFG['maxGrowthRate','H2']=2
MFG['keyResource',1]='H2'
MFG['stoichiom',]=c(4,1,1,2)
Archea=data.frame(MFG,stringsAsFactors=FALSE)

#make resourceSysInfo data frame
Rmat=matrix(NA,ncol=4,nrow=4,dimnames=list(c('startValue','inflowRate',
'washOut','molarMass'),c('H2','CO2','CH4','H2O')))
Rmat['startValue',]=c(1,1,0,0)
Rmat['inflowRate',]=c(1,5,0,0)
Rmat['washOut',]=c(0.1,0.1,0.1,0.1)
Rmat['molarMass',]=c(2,44,16,18)

#make microbeSysInfo data frame
Mmat=matrix(NA,ncol=1,nrow=3,dimnames=list(c('startValue','inflowRate',
'washOut'),c('Archea')))
Mmat['startValue',]=1
Mmat['inflowRate',]=0
Mmat['washOut',]=0.1

out=microPopModel(
    microbeNames='Archea',
    times=seq(0,50,0.1),
    resourceSysInfo=data.frame(Rmat,stringsAsFactors=FALSE),
    microbeSysInfo=data.frame(Mmat,stringsAsFactors=FALSE)
)
}
