% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orfs.R
\name{orfLength}
\alias{orfLength}
\title{ORF lengths}
\usage{
orfLength(gff.table)
}
\arguments{
\item{gff.table}{A \code{gff.table} (\code{data.frame}) with genomic features information.}
}
\value{
A vector of ORF lengths, measured as the number of codons.
}
\description{
Computes the lengths, in codons, of all ORFs in a \code{gff.table}.
}
\details{
Note that the length returned is the number of codons in the ORF, not the number of bases. The number
of bases should be 3 times the length. The number of amino acids should be the length minus 1 (stop codon) if the ORF is 
not truncated. See \code{\link{findOrfs}} for more on \code{gff.table}s.
}
\examples{
# See the example in the Help-file for findOrfs.

}
\seealso{
\code{\link{findOrfs}}, \code{\link{lorfs}}.
}
\author{
Lars Snipen and Kristian Hovde Liland.
}
