% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/micss.R
\name{lrv.spc.bartlett}
\alias{lrv.spc.bartlett}
\title{lrv.spc.bartlett}
\usage{
lrv.spc.bartlett(x, kmax = NULL)
}
\arguments{
\item{x}{Stationary variable. A numeric vector.}

\item{kmax}{Maximum lag to be used for the long-run estimation of the variance.}
}
\value{
Estimation of the long-run variance.
}
\description{
Estimation of the long-run variance using the Barlett window.
}
\details{
Estimates the log-run fourth order moment when x are the squares of a variable.
}
\examples{
lrv.spc.bartlett(rnorm(100))
}
\references{
D. Sul, P.C.B. Phillips & C.Y. Choi (2005): Prewhitening Bias in HAC Estimation, Oxford Bulletin of Economics and Statistics 67, 517-546.

D.W.K. Andrews & J.C. Monahan (1992): An Improved Heteroskedasticity and Autocorrelation Consistent Covariance Matrix Estimator. Econometrica 60, 953-966.
}
