% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/same_content.R
\name{same_content}
\alias{same_content}
\title{Test for equal content between two data tables}
\usage{
same_content(x, y)
}
\arguments{
\item{x}{Data frame to be compared. Same as \code{target} argument in
\code{all.equal()}}

\item{y}{Data frame to be compared. Same as \code{current} argument in
\code{all.equal()}}
}
\value{
Either TRUE or a description of the differences between \code{x}
and \code{y}.
}
\description{
Test of data equality between data.table objects. Convenience function used
in package articles.
}
\details{
Wrapper around \code{all.equal()} for class data.table that ignores row order,
column order, and data.table keys. Both inputs must be date frames.
Equivalent to:

\code{all.equal(target, current, ignore.row.order = TRUE, ignore.col.order =
TRUE)}
}
\examples{
# Same information and ignore row order, column order
x <- toy_student[order(mcid), .(mcid, institution)]
y <- toy_student[order(institution), .(institution, mcid)]
same_content(x, y)

# Different number of rows
x <- toy_student[1:10]
y <- toy_student[1:11]
same_content(x, y)

# Different column names
x <- toy_student[, .(mcid)]
y <- toy_student[, .(institution)]
same_content(x, y)

# Different number of columns and column names
x <- toy_student[, .(mcid)]
y <- toy_student[, .(mcid, institution)]
same_content(x, y)

# Different number of rows, number of columns, and column names
x <- toy_student
y <- toy_term
same_content(x, y)

# Different row content
x <- toy_student[1:10]
y <- toy_student[2:11]
same_content(x, y)
}
