% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted.R
\name{weighted}
\alias{weighted}
\alias{augmented}
\alias{shuffled}
\alias{latticized}
\alias{weights.weighted}
\title{Weighted Data Frames}
\usage{
weighted(data, weights = NULL)

augmented(data, weights = NULL, size = nrow(data), r = 0.01)

shuffled(data, weights = NULL, size = nrow(data))

latticized(
  data,
  weights = NULL,
  k = 10L,
  type = 0L,
  use.catchall = TRUE,
  catchall = "(others)",
  frames = list(),
  keep.mean = TRUE
)

\method{weights}{weighted}(object, ...)
}
\arguments{
\item{data}{a data frame.}

\item{weights}{a numeric vector of sample weights for each observation in \code{data}.}

\item{size}{integer. The number of random observations whose values are sampled from the marginal distribution of each variable.}

\item{r}{a numeric value specifying the ratio of the total weights for the random observations to the sum of sample weights. The weight for the random observations is calculated as \code{sum(attr(data, "weights")) * r / size}.}

\item{k}{integer. The maximum number of sample points for each variable. If not positive, all unique values are used as sample points.}

\item{type}{integer. The type of encoding of quantitative variables to be passed to \code{numeric.encoder()}.}

\item{use.catchall}{logical. If \code{TRUE}, less frequent levels of factor variables are dropped and replaced by the catchall level.}

\item{catchall}{a character string to be used as the catchall level.}

\item{frames}{a named list of encoding frames ("numeric.frame" or "factor.frame" objects).}

\item{keep.mean}{logical. If \code{TRUE}, the representative values of each group is the average of the corresponding group.}

\item{object}{a data frame with the attribute "weights".}

\item{...}{not used.}
}
\value{
\code{weighted()} returns a data frame with the attribute "weights".
\code{augmented()} returns a weighted data frame of the original data and the shuffled data with relatively small weights.
\code{shuffled()} returns a weighted data frame of the shuffled data.
\code{latticized()} returns a weighted data frame of latticized data, whose values are grouped and replaced by the representative value of the corresponding group.
}
\description{
\code{weighted()} returns a data frame with sample weights.
}
\details{
\code{weighted()} returns a data frame with the "weights" attribute that can be extracted using \code{stats::weights()}.
\code{augmented()}, \code{shuffled()} and \code{latticized()} return a weighted data frame with some data modifications.
These functions are designed for use with \code{interpret()}.
As the modified data frames do not preserve the original correlation structure of the variables, the response variable (y) should always be replaced by the model predictions (yhat).
}
\examples{
set.seed(42)
x1 <- runif(1000L, -1, 1)
x2 <- x1 + runif(1000L, -1, 1)
weights <- (abs(x1) + abs(x2)) / 2
x <- data.frame(x1, x2)
xw <- weighted(x, weights)
ggplot2::ggplot(xw, ggplot2::aes(x1, x2, alpha = weights(xw))) +
  ggplot2::geom_point() +
  ggplot2::ggtitle("weighted")
xs <- shuffled(xw)
ggplot2::ggplot(xs, ggplot2::aes(x1, x2, alpha = weights(xs))) +
  ggplot2::geom_point() +
  ggplot2::ggtitle("shuffled")
xa <- augmented(xw)
ggplot2::ggplot(xa, ggplot2::aes(x1, x2, alpha = weights(xa))) +
  ggplot2::geom_point() +
  ggplot2::ggtitle("augmented")
xl <- latticized(xw)
ggplot2::ggplot(xl, ggplot2::aes(x1, x2, size = weights(xl))) +
  ggplot2::geom_point() +
  ggplot2::ggtitle("latticized")
}
