% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Mutator.R
\name{Mutator}
\alias{Mutator}
\title{Mutator Base Class}
\description{
Base class representing mutation operations, inheriting from \code{\link{MiesOperator}}.

Mutations get a table of individuals as input and return a table of modified individuals as output. Individuals are acted on as
individuals: every line of output corresponds to the same line of input, and presence or absence of other input lines does not
affect the result.

Mutation operations are performed in ES algorithms to facilitate exploration of the search space around individuals.
}
\section{Inheriting}{

\code{Mutator} is an abstract base class and should be inherited from. Inheriting classes should implement the private \verb{$.mutate()}
function. The user of the object calls \verb{$operate()}, and the arguments are passed on to private \verb{$.mutate()} after checking that
the operator is primed, and that the \code{values} argument conforms to the primed domain. Typically, the \verb{$initialize()} function
should also be overloaded, and optionally the \verb{$prime()} function; they should call their \code{super} equivalents.

In many cases, it is advisable to inherit from one of the abstract subclasses, such as \code{\link{MutatorNumeric}}, or \code{\link{MutatorDiscrete}}.
}

\seealso{
Other base classes: 
\code{\link{Filtor}},
\code{\link{FiltorSurrogate}},
\code{\link{MiesOperator}},
\code{\link{MutatorDiscrete}},
\code{\link{MutatorNumeric}},
\code{\link{OperatorCombination}},
\code{\link{Recombinator}},
\code{\link{RecombinatorPair}},
\code{\link{Scalor}},
\code{\link{Selector}},
\code{\link{SelectorScalar}}

Other mutators: 
\code{\link{MutatorDiscrete}},
\code{\link{MutatorNumeric}},
\code{\link{OperatorCombination}},
\code{\link{dict_mutators_cmpmaybe}},
\code{\link{dict_mutators_erase}},
\code{\link{dict_mutators_gauss}},
\code{\link{dict_mutators_maybe}},
\code{\link{dict_mutators_null}},
\code{\link{dict_mutators_proxy}},
\code{\link{dict_mutators_sequential}},
\code{\link{dict_mutators_unif}}
}
\concept{base classes}
\concept{mutators}
\section{Super class}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{Mutator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Mutator-new}{\code{Mutator$new()}}
\item \href{#method-Mutator-clone}{\code{Mutator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="prime"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-prime'><code>miesmuschel::MiesOperator$prime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Mutator-new"></a>}}
\if{latex}{\out{\hypertarget{method-Mutator-new}{}}}
\subsection{Method \code{new()}}{
Initialize base class components of the \code{Mutator}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Mutator$new(
  param_classes = c("ParamLgl", "ParamInt", "ParamDbl", "ParamFct"),
  param_set = ps(),
  packages = character(0),
  dict_entry = NULL,
  own_param_set = quote(self$param_set)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_classes}}{(\code{character})\cr
Classes of parameters that the operator can handle. May contain any of \code{"ParamLgl"}, \code{"ParamInt"}, \code{"ParamDbl"}, \code{"ParamFct"}.
Default is all of them.\cr
The \verb{$param_classes} field will reflect this value.}

\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}} | \code{list} of \code{expression})\cr
Strategy parameters of the operator. This should be created by the subclass and given to \code{super$initialize()}.
If this is a \code{\link[paradox:ParamSet]{ParamSet}}, it is used as the \code{MiesOperator}'s \code{\link[paradox:ParamSet]{ParamSet}}
directly. Otherwise it must be a \code{list} of expressions e.g. created by \code{alist()} that evaluate to \code{\link[paradox:ParamSet]{ParamSet}}s,
possibly referencing \code{self} and \code{private}.
These \code{\link[paradox:ParamSet]{ParamSet}} are then combined using a \code{\link[paradox:ParamSetCollection]{ParamSetCollection}}.
Default is the empty \code{\link[paradox:ParamSet]{ParamSet}}.\cr
The \verb{$param_set} field will reflect this value.}

\item{\code{packages}}{(\code{character})
Packages that need to be loaded for the operator to function. This should
be declared so these packages can be loaded when operators run on parallel
instances. Default is \code{character(0)}.\cr
The \verb{$packages} field will reflect this values.}

\item{\code{dict_entry}}{(\code{character(1)} | \code{NULL})\cr
Key of the class inside the \code{\link[mlr3misc:Dictionary]{Dictionary}} (usually one of
\code{\link{dict_mutators}}, \code{\link{dict_recombinators}}, \code{\link{dict_selectors}}), where it can
be retrieved using a \link[=mut]{short access function}. May be \code{NULL} if the operator
is not entered in a dictionary.\cr
The \verb{$dict_entry} field will reflect this value.}

\item{\code{own_param_set}}{(\code{language})\cr
An expression that evaluates to a \code{\link[paradox:ParamSet]{ParamSet}} indicating the configuration parameters that are entirely owned by
this operator class (and not proxied from a construction argument object). This should be \code{quote(self$param_set)} (the default) when
the \code{param_set} argument is not a list of expressions.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Mutator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Mutator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Mutator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
