% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scalor.R
\name{Scalor}
\alias{Scalor}
\title{Scalor Base Class}
\description{
Base class representing ranking operations, inheriting from \code{\link{MiesOperator}}.

A \code{\link{Scalor}} gets a table of individuals as input, along with information on the individuals' performance values
and returns a vector of a possible scalarization of individuals' fitness (or other qualities).

\code{\link{Scalor}}s can be used by \code{\link{Selector}}s as a basis to select individuals by. This way it is possible to have tournament
selection (\code{\link{SelectorTournament}}) or elite selection (\code{\link{SelectorBest}}) based on different, configurable qualities of
individuals.

Unlike most other operator types inheriting from \code{\link{MiesOperator}}, the \verb{$operate()} function has two arguments, which are passed on to \verb{$.scale()}
\itemize{
\item \code{values} :: \code{data.frame}\cr
Individuals to operate on. Must pass the check of the \code{\link[paradox:ParamSet]{ParamSet}} given in the last \verb{$prime()} call
and may not have any missing components.
\item \code{fitnesses} :: \code{numeric} | \code{matrix}\cr
Fitnesses for each individual given in \code{values}. If this is a \code{numeric}, then its length must be equal to the number of rows in \code{values}. If
this is a \code{matrix}, if number of rows must be equal to the number of rows in \code{values}, and it must have one column when doing single-crit optimization
and one column each for each "criterion" when doing multi-crit optimization.\cr
Note that fitness values are always \emph{maximized}, both in single- and multi-criterion optimization, so objective output is multiplied with \code{-1} if it
is tagged as \code{"minimize"}.
}

The return value of an operation should be a numeric vector with one finite value for each entry of \code{values}, assigning high values to individuals in
some way more "desirable" than others with low values.
}
\section{Inheriting}{

\code{Scalor} is an abstract base class and should be inherited from. Inheriting classes should implement the private \verb{$.scale()}
function. The user of the object calls \verb{$operate()}, and the arguments are passed on to private \verb{$.scale()} after checking that
the operator is primed, that the \code{values} argument conforms to the primed domain and that other values match. Typically, the \verb{$initialize()} function
should also be overloaded, and optionally the \verb{$prime()} function; they should call their \code{super} equivalents.
}

\seealso{
Other base classes: 
\code{\link{Filtor}},
\code{\link{FiltorSurrogate}},
\code{\link{MiesOperator}},
\code{\link{Mutator}},
\code{\link{MutatorDiscrete}},
\code{\link{MutatorNumeric}},
\code{\link{OperatorCombination}},
\code{\link{Recombinator}},
\code{\link{RecombinatorPair}},
\code{\link{Selector}},
\code{\link{SelectorScalar}}

Other scalors: 
\code{\link{dict_scalors_aggregate}},
\code{\link{dict_scalors_domcount}},
\code{\link{dict_scalors_fixedprojection}},
\code{\link{dict_scalors_hypervolume}},
\code{\link{dict_scalors_nondom}},
\code{\link{dict_scalors_one}},
\code{\link{dict_scalors_proxy}},
\code{\link{dict_scalors_single}}
}
\concept{base classes}
\concept{scalors}
\section{Super class}{
\code{\link[miesmuschel:MiesOperator]{miesmuschel::MiesOperator}} -> \code{Scalor}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{supported}}{(\code{character})\cr
Optimization supported by this \code{Scalor}, can be \code{"single-crit"}, \code{"multi-crit"}, or both.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Scalor-new}{\code{Scalor$new()}}
\item \href{#method-Scalor-clone}{\code{Scalor$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="help"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-help'><code>miesmuschel::MiesOperator$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="operate"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-operate'><code>miesmuschel::MiesOperator$operate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="prime"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-prime'><code>miesmuschel::MiesOperator$prime()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="print"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-print'><code>miesmuschel::MiesOperator$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="miesmuschel" data-topic="MiesOperator" data-id="repr"><a href='../../miesmuschel/html/MiesOperator.html#method-MiesOperator-repr'><code>miesmuschel::MiesOperator$repr()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Scalor-new"></a>}}
\if{latex}{\out{\hypertarget{method-Scalor-new}{}}}
\subsection{Method \code{new()}}{
Initialize base class components of the \code{Mutator}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Scalor$new(
  param_classes = c("ParamLgl", "ParamInt", "ParamDbl", "ParamFct"),
  param_set = ps(),
  supported = c("single-crit", "multi-crit"),
  packages = character(0),
  dict_entry = NULL,
  own_param_set = quote(self$param_set)
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_classes}}{(\code{character})\cr
Classes of parameters that the operator can handle. May contain any of \code{"ParamLgl"}, \code{"ParamInt"}, \code{"ParamDbl"}, \code{"ParamFct"}.
Default is all of them.\cr
The \verb{$param_classes} field will reflect this value.}

\item{\code{param_set}}{(\code{\link[paradox:ParamSet]{ParamSet}} | \code{list} of \code{expression})\cr
Strategy parameters of the operator. This should be created by the subclass and given to \code{super$initialize()}.
If this is a \code{\link[paradox:ParamSet]{ParamSet}}, it is used as the \code{MiesOperator}'s \code{\link[paradox:ParamSet]{ParamSet}}
directly. Otherwise it must be a \code{list} of expressions e.g. created by \code{alist()} that evaluate to \code{\link[paradox:ParamSet]{ParamSet}}s,
possibly referencing \code{self} and \code{private}.
These \code{\link[paradox:ParamSet]{ParamSet}} are then combined using a \code{\link[paradox:ParamSetCollection]{ParamSetCollection}}.
Default is the empty \code{\link[paradox:ParamSet]{ParamSet}}.\cr
The \verb{$param_set} field will reflect this value.}

\item{\code{supported}}{(\code{character})\cr
Subset of \code{"single-crit"} and \code{"multi-crit"}, indicating wether single and / or multi-criterion optimization is supported.
Default both of them.\cr
The \verb{$supported} field will reflect this value.}

\item{\code{packages}}{(\code{character})
Packages that need to be loaded for the operator to function. This should
be declared so these packages can be loaded when operators run on parallel
instances. Default is \code{character(0)}.\cr
The \verb{$packages} field will reflect this values.}

\item{\code{dict_entry}}{(\code{character(1)} | \code{NULL})\cr
Key of the class inside the \code{\link[mlr3misc:Dictionary]{Dictionary}} (usually one of
\code{\link{dict_mutators}}, \code{\link{dict_recombinators}}, \code{\link{dict_selectors}}), where it can
be retrieved using a \link[=mut]{short access function}. May be \code{NULL} if the operator
is not entered in a dictionary.\cr
The \verb{$dict_entry} field will reflect this value.}

\item{\code{own_param_set}}{(\code{language})\cr
An expression that evaluates to a \code{\link[paradox:ParamSet]{ParamSet}} indicating the configuration parameters that are entirely owned by
this operator class (and not proxied from a construction argument object). This should be \code{quote(self$param_set)} (the default) when
the \code{param_set} argument is not a list of expressions.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Scalor-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Scalor-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Scalor$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
