% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_create.R
\name{create}
\alias{create}
\alias{create_empty}
\alias{create_complete}
\alias{create_ring}
\alias{create_star}
\alias{create_tree}
\alias{create_lattice}
\alias{create_components}
\alias{create_core}
\title{Make networks with defined structures}
\usage{
create_empty(n)

create_complete(n, directed = FALSE)

create_ring(n, width = 1, directed = FALSE, ...)

create_star(n, directed = FALSE)

create_tree(n, directed = FALSE, width = 2)

create_lattice(n, directed = FALSE)

create_components(n, membership = NULL)

create_core(n, membership = NULL)
}
\arguments{
\item{n}{Given:
\itemize{
\item A single integer, e.g. \code{n = 10},
a one-mode network will be created.
\item A vector of two integers, e.g. \code{n = c(5,10)},
a two-mode network will be created.
\item A migraph-compatible object,
a network of the same dimensions will be created.
}}

\item{directed}{Logical whether the graph should be directed.
By default \code{directed = FALSE}.
If the opposite direction is desired, use \code{to_redirected()}.}

\item{width}{Integer specifying the width or breadth
of the ring or branches.}

\item{...}{Additional arguments passed on to \code{{igraph}}.}

\item{membership}{A vector of partition membership as integers.
If left as \code{NULL} (the default), nodes in each mode will be
assigned to two, equally sized partitions.}
}
\value{
By default an \code{igraph} object is returned,
but this can be coerced into other types of objects
using \code{as_edgelist()}, \code{as_matrix()},
\code{as_tidygraph()}, or \code{as_network()}.
}
\description{
These functions create networks with particular structural properties.
They can create either one-mode or two-mode networks.
To create a one-mode network, pass the main argument \code{n} a single integer,
indicating the number of nodes in the network.
To create a two-mode network, pass \code{n} a vector of \emph{two} integers,
where the first integer indicates the number of nodes in the first mode,
and the second integer indicates the number of nodes in the second mode.
As an alternative, an existing network can be provided to \code{n}
and the number of modes and nodes will be inferred.

By default, all networks are created as undirected.
This can be overruled with the argument \code{directed = TRUE}.
This will return a directed network in which the arcs are
out-facing or equivalent.
This direction can be swapped using \code{to_redirected()}.
In two-mode networks, this is ignored.
}
\section{Functions}{
\itemize{
\item \code{create_empty}: Creates an empty graph of the given dimensions.

\item \code{create_complete}: Creates a filled graph of the given dimensions,
with every possible tie realised.

\item \code{create_ring}: Creates a ring or chord graph of the given dimensions
that loops around is of a certain width or thickness.

\item \code{create_star}: Creates a graph of the given dimensions
that has a maximally central node

\item \code{create_tree}: Creates a graph of the given dimensions with successive branches.

\item \code{create_lattice}: Creates a graph of the given dimensions with ties to all neighbouring nodes

\item \code{create_components}: Creates a graph in which the nodes are clustered
into separate components.

\item \code{create_core}: Creates a graph with a certain proportion of nodes
being core nodes, densely tied to each other and peripheral nodes,
and the rest peripheral, tied only to the core.
}}

\examples{
autographr(create_empty(10)) + autographr(create_complete(10))
autographr(create_empty(c(8,6))) + autographr(create_complete(c(8,6)))
autographr(create_ring(8, width = 2)) +
autographr(create_ring(c(8,6), width = 2))
autographr(create_star(12)) +
autographr(create_star(12, directed = TRUE)) +
autographr(create_star(c(12,1)))
autographr(create_tree(c(7,8), directed = TRUE)) +
autographr(create_tree(15, directed = TRUE), "tree") +
autographr(create_tree(15, directed = TRUE, width = 3), "tree")
autographr(create_lattice(5), layout = "kk") +
autographr(create_lattice(c(5,5))) +
autographr(create_lattice(c(5,5,5)))
autographr(create_components(10, membership = c(1,1,1,2,2,2,3,3,3,3)))
autographr(create_components(c(10, 12)))
autographr(create_core(6)) +
autographr(create_core(6, membership = c(1,1,1,1,2,2))) +
autographr(create_core(c(6,6)))
}
\seealso{
\link{as}

Other makes: 
\code{\link{generate}},
\code{\link{read}}
}
\concept{makes}
