% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/edge.R
\name{edge}
\alias{edge}
\alias{edge_mutual}
\alias{edge_multiple}
\alias{edge_loop}
\alias{edge_betweenness}
\alias{edge_closeness}
\title{Identifying edges by certain properties}
\usage{
edge_mutual(object)

edge_multiple(object)

edge_loop(object)

edge_betweenness(object)

edge_closeness(object)
}
\arguments{
\item{object}{An object of a migraph-consistent class:
\itemize{
\item matrix, from base R
\item edgelist, a data frame from base R or tibble from tibble
\item igraph, from the igraph package
\item network, from the network package
\item tbl_graph, from the tidygraph package
}}
}
\description{
Identifying edges by certain properties
}
\section{Functions}{
\itemize{
\item \code{edge_mutual}: Identify edges that are mutual/reciprocated

\item \code{edge_multiple}: Identify edges that are multiples

\item \code{edge_loop}: Identify edges that are loops

\item \code{edge_betweenness}: Calculate number of shortest paths going through an edge

\item \code{edge_closeness}: Calculate the closeness of each edge to each other edge
in the network.
}}

\examples{
edge_mutual(ison_algebra)
edge_multiple(ison_algebra)
edge_loop(ison_algebra)
(eb <- edge_betweenness(ison_adolescents))
plot(eb)
ison_adolescents \%>\% 
  activate(edges) \%>\% mutate(weight = eb) \%>\% 
  autographr()
(ec <- edge_closeness(ison_adolescents))
plot(ec)
ison_adolescents \%>\% 
  activate(edges) \%>\% mutate(weight = ec) \%>\% 
  autographr()
}
