% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/softmax.R
\name{softmax}
\alias{softmax}
\title{Multiple-instance logistic regression via softmax function}
\usage{
softmax(y, x, bag, alpha = 0, ...)
}
\arguments{
\item{y}{a vector. Bag-level binary labels.}

\item{x}{the design matrix. The number of rows of \code{x} must be equal to the length of \code{y}.}

\item{bag}{a vector, bag id.}

\item{alpha}{A non-negative realnumber, the softmax parameter.}

\item{...}{arguments to be passed to the \code{optim} function.}
}
\value{
a list including coefficients and fitted values.
}
\description{
This function calculates the alternative maximum likelihood estimation for 
multiple-instance logistic regression
through a softmax function (Xu and Frank, 2004; Ray and Craven, 2005).
}
\examples{
set.seed(100)
beta <- runif(10, -5, 5)
trainData <- DGP(70, 3, beta)
testData <- DGP(30, 3, beta)
# Fit softmax-MILR model S(0)
softmax_result <- softmax(trainData$Z, trainData$X, trainData$ID, alpha = 0)
coef(softmax_result)      # coefficients
fitted(softmax_result)                    # fitted bag labels
fitted(softmax_result, type = "instance") # fitted instance labels
predict(softmax_result, testData$X, testData$ID)                    # predicted bag labels
predict(softmax_result, testData$X, testData$ID, type = "instance") # predicted instance labels
# Fit softmax-MILR model S(3)
softmax_result <- softmax(trainData$Z, trainData$X, trainData$ID, alpha = 3)
}
\references{
\enumerate{
 \item S. Ray, and M. Craven. (2005) Supervised versus multiple instance learning: 
 An empirical comparsion. in Proceedings of the 22nd International Conference on 
 Machine Learnings, ACM, 697--704.
 \item X. Xu, and E. Frank. (2004) Logistic regression and boosting for labeled bags 
 of instances. in Advances in Knowledge Discovery and Data Mining, Springer, 272--281.
}
}
