% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplesize.R
\name{sampleSizeCont}
\alias{sampleSizeCont}
\title{Sample size calculator for continuous outcomes}
\usage{
sampleSizeCont(Dm, SD, a = 0.05, b = 0.2, K = 1)
}
\arguments{
\item{Dm}{Anticipated absolute difference in means between the two groups
(intervention and control).}

\item{SD}{Anticipated standard deviation for the outcome.}

\item{a}{False positive rate (alpha). Defaults to 0.05 (5\%).}

\item{b}{False negative rate (beta). Defaults to 0.2. 
Power is one minus beta; thus the default is 80\% power.}

\item{K}{Ratio of intervention group size to control group size. 
Defaults to 1, meaning both groups have the same size. 
Set to infinity (\code{Inf}) in order to calculate sample size for a 
\emph{single-group study}, see details below.}
}
\value{
An integer vector of length 2, with the sample sizes for the 
    control and intervention groups. 

    If \code{K=Inf}, then the sample size calculation is not for a study
    with two groups, but for a single-group study in which we try to show
    a difference from a fixed known population mean. In that case, argument 
    \code{Dm} represents the absolute difference between the study mean and
    population mean, rather than the difference in means between two groups.
    And the return value is a single value, i.e. the sample size of the study.
}
\description{
Calculates sample size for a trial with a continuous outcome, for a given
power and false positive rate.
}
\examples{
# Sample size for a trial with 2:1 randomization, aiming to show a mean
# difference of 2 for a continuous outcome with a standard deviation of 3, 
# with 90\\% power.
sampleSizeCont(2, 3, b=0.1, K=2)

# Similar for a single-group study aiming to show a difference of 2 against
# a known population mean. 
sampleSizeCont(2, 3, b=0.1, K=Inf)

}
