% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mapReactions.R
\name{mapReactions}
\alias{mapReactions}
\title{Return reactions from a reference data.frame by a selected column}
\usage{
mapReactions(reactionList, referenceData, by, inverse = FALSE)
}
\arguments{
\item{reactionList}{A set of values to be mapped}

\item{referenceData}{A data.frame to be used as reference}

\item{by}{A data.frame column id or \code{'bool'}.}

\item{inverse}{A boolean value to define if inverted selection must be returned}
}
\description{
This function takes a set of values and return all associated data in a reference data.frame
}
\examples{
# Loading a CSV file
glycolysis <- read.csv2(system.file("extdata", "glycolysisKEGG.csv", package = "minval"))

# Data structure
head(glycolysis)

# Mapping reactions
mapReactions(
 reactionList = isValidSyntax(glycolysis$REACTION), 
 referenceData = glycolysis, 
 by = "bool"
 )

# Mapping inverse
mapReactions(
 reactionList = isValidSyntax(glycolysis$REACTION), 
 referenceData = glycolysis, 
 by = "bool", 
 inverse = TRUE
 )
}
\author{
Daniel Camilo Osorio Hurtado <dcosorioh@unal.edu.co>
}

