% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/launchers.R
\name{host_url}
\alias{host_url}
\title{Host URL Constructor}
\usage{
host_url(ws = FALSE, tls = FALSE, port = 0)
}
\arguments{
\item{ws}{[default FALSE] logical value whether to use a WebSockets 'ws://'
or else TCP 'tcp://' scheme.}

\item{tls}{[default FALSE] logical value whether to use TLS in which case the
scheme used will be either 'wss://' or 'tls+tcp://' accordingly.}

\item{port}{[default 0] numeric port to use. This should be open to
connections from the network addresses the daemons are connecting from.
'0' is a wildcard value that automatically assigns a free ephemeral port.}
}
\value{
A character string comprising a valid host URL.
}
\description{
Automatically constructs a valid host URL (at which daemons may connect)
    based on the computer's hostname. This may be supplied directly to the
    'url' argument of \code{\link{daemons}}.
}
\details{
This implementation relies on using the host name of the computer
    rather than an IP address and typically works on local networks, although
    this is not always guaranteed. If unsuccessful, substitute an IPv4 or
    IPv6 address in place of the hostname.
}
\examples{
host_url()
host_url(ws = TRUE)
host_url(tls = TRUE)
host_url(ws = TRUE, tls = TRUE, port = 5555)

}
