library(mirai)

nanotest <- function(x) invisible(x || stop())
nanotestn <- function(x) invisible(is.null(x) || stop())
nanotestz <- function(x) invisible(x == 0L || stop())
nanotesto <- function(x) invisible(x == 1L || stop())
nanotestp <- function(x) invisible(is.character(capture.output(print(x))) || stop())
nanotesterr <- function(x, e = "")
  invisible(grepl(e, tryCatch(x, error = identity)[["message"]], fixed = TRUE) || stop())

nanotest(is.list(daemons()))
nanotestz(daemons()[["connections"]])
nanotestz(daemons()[["daemons"]])
nanotesto(daemons(1L, dispatcher = FALSE))
me <- mirai(mirai::mirai(), .timeout = 2000L)
nanotest(is_mirai_error(call_mirai(me)$data) || is_error_value(me$data))
nanotest(!is_mirai_interrupt(me$data))
nanotest(is_error_value(me[["data"]]))
nanotestp(me$data)
df <- data.frame(a = 1, b = 2)
dm <- mirai(as.matrix(df), .args = list(df), .timeout = 2000L)
nanotest(is_mirai(call_mirai(dm)))
nanotest(!unresolved(dm))
nanotest(is.matrix(dm$data) || is_error_value(dm$data))
nanotestn(stop_mirai(dm))
nanotesto(daemons()[["connections"]])
nanotesto(daemons()[["daemons"]])
nanotestz(daemons(0L))
nanotestz(daemons()[["connections"]])
nanotestz(daemons()[["daemons"]])
nanotesterr(daemons(url = "URL"), "Invalid argument")
nanotesterr(daemons(-1), "zero or greater")
nanotesterr(daemons(raw(0L)), "must be numeric")
nanotesterr(server("URL"), "Invalid argument")
nanotesterr(dispatcher(client = "URL"), "at least one")
nanotestz(daemons(0L))
nanotest(is_mirai_interrupt(r <- mirai:::mk_interrupt_error()))
nanotestp(r)
Sys.sleep(1L)
n <- 3L
m <- mirai({
  Sys.sleep(0.1)
  q <- m + n + 1L
  q / m
}, m = 2L, .args = list(n))
b <- .(m %>>% rnorm() %>>% as.character)
b2 <- .(m$data %>>% as.character())
nanotestp(b)
nanotest(inherits(call_mirai(m), "mirai"))
nanotest(m$data == 3L || is_error_value(m$data))
nanotest(identical(call_mirai(m), m))
nanotest(is_mirai(m))
nanotest(!unresolved(b))
nanotest(!unresolved(b2$data))
nanotest(length(b$data) == 3L)
nanotest(is.environment(b) && is.character(b$data))
nanotest(is.environment(b2) && is.character(b2$data))
Sys.sleep(2.2)
nanotestp(m)
nanotestp(b)
`lang obj` <- quote(m + n + 2L)
args <- list(m = 2L, n = 4L)
m <- mirai(.expr = `lang obj`, .args = args, .timeout = 2000L)
nanotest(call_mirai(m)$data == 8L || is_error_value(m$data))
Sys.sleep(2.2)
nanotest(daemons(url = value <- mirai:::auto_tokenized_url(), dispatcher = FALSE) == value)
nanotestz(daemons(0L))
Sys.sleep(0.5)
nanotest(daemons(n = 2L, url = value <- "ws://:0", dispatcher = FALSE) != value)
nanotestz(daemons(0L))
Sys.sleep(0.5)
nanotesto(daemons(url = "ws://:0", token = TRUE))
nanotestz(daemons(0L))
Sys.sleep(1L)
nanotesto(daemons(url = "tcp://:0", token = TRUE))
nanotestz(daemons(0L))
Sys.sleep(1L)
nanotesto(daemons(1L, dispatcher = FALSE, idletime = 500L, timerstart = 1L, cleanup = 0L, .compute = "new"))
Sys.sleep(2L)
mn <- mirai("test1", .compute = "new")
mp <- mirai("test2", .compute = "new")
Sys.sleep(1L)
nanotest(mn$data == "test1")
nanotest(mp$data == "test2")
Sys.sleep(1L)

if (.Platform[["OS.type"]] != "windows") {
  nanotest(daemons(.compute = "new")[["connections"]] == 0L)
  nanotestz(daemons(0L, .compute = "new"))
  Sys.sleep(1L)
  nanotest(daemons(n = 2, "ws://:0") == 2L)
  Sys.sleep(1L)
  nanotest(is.matrix(status <- daemons()[["daemons"]]))
  nanotest(is.character(dn1 <- dimnames(status)[[1L]]))
  nanotest(is.integer(attr(dn1, "dispatcher_pid")))
  nanotest(is.character(parse1 <- nanonext::parse_url(dn1[1L])))
  nanotest(is.character(parse2 <- nanonext::parse_url(dn1[2L])))
  nanotest((port <- as.integer(parse1[["port"]])) > 0L)
  nanotest(as.integer(parse2[["port"]]) == port)
  nanotest(parse1[["path"]] == "/1")
  nanotest(parse2[["path"]] == "/2")
  nanotestz(sum(status[, "online"]))
  nanotestz(sum(status[, "instance"]))
  nanotestz(sum(status[, "assigned"]))
  nanotestz(sum(status[, "complete"]))
  nanotest(is.character(saisei(i = 1L)))
  nanotestn(saisei(i = 10L))
  Sys.sleep(0.5)
  nanotestz(daemons(0))
  Sys.sleep(1L)
  nanotest(daemons(n = 2, "tcp://127.0.0.1:0") == 2L)
  Sys.sleep(1L)
  nanotest(is.integer(launch_server(row.names(daemons()[["daemons"]])[1L], maxtasks = 1L)))
  Sys.sleep(1L)
  nanotest(is.matrix(status <- daemons()[["daemons"]]))
  nanotest(is.character(dn1 <- dimnames(status)[[1L]]))
  nanotest(is.integer(attr(dn1, "dispatcher_pid")))
  nanotest(is.character(parse1 <- nanonext::parse_url(dn1[1L])))
  nanotest(is.character(parse2 <- nanonext::parse_url(dn1[2L])))
  nanotest((port <- as.integer(parse1[["port"]])) > 0L)
  nanotest(as.integer(parse2[["port"]]) != port)
  nanotesto(sum(status[, "online"]))
  nanotesto(sum(status[, "instance"]))
  nanotestz(sum(status[, "assigned"]))
  nanotestz(sum(status[, "complete"]))
  nanotestz(daemons(0))
  Sys.sleep(1L)
  option <- 15L
  nanotesto(daemons(1, dispatcher = TRUE, maxtasks = 10L, walltime = 2000L, token = TRUE, lock = TRUE, cleanup = option))
  Sys.sleep(1L)
  mq <- mirai("server", .timeout = 2000)
  nanotest(call_mirai(mq)$data == "server" || is_error_value(mq$data))
  nanotest(is.matrix(status <- daemons()[["daemons"]]))
  nanotesto(status[, "online"])
  nanotesto(status[, "instance"])
  nanotestz(daemons(0))
  Sys.sleep(2L)
}
