% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mirai.R
\name{everywhere}
\alias{everywhere}
\title{Evaluate Everywhere}
\usage{
everywhere(.expr, ..., .args = list(), .compute = "default")
}
\arguments{
\item{.expr}{an expression to evaluate asynchronously (of arbitrary length,
wrapped in \{ \} where necessary), \strong{or else} a pre-constructed language
object.}

\item{...}{(optional) \strong{either} named arguments (name = value pairs)
specifying objects referenced, but not defined, in \code{.expr}, \strong{or} an
environment containing such objects. See 'evaluation' section below.}

\item{.args}{(optional) \strong{either} a named list specifying objects
referenced, but not defined, in \code{.expr}, \strong{or} an environment containing
such objects. These objects will remain local to the evaluation environment
as opposed to those supplied in \code{...} above - see 'evaluation' section
below.}

\item{.compute}{[default 'default'] character value for the compute profile
to use (each compute profile has its own independent set of daemons).}
}
\value{
A list of mirai executed on each daemon. This may be waited for and
inspected using \code{\link[=call_mirai]{call_mirai()}} or \code{\link[=collect_mirai]{collect_mirai()}}.
}
\description{
Evaluate an expression 'everywhere' on all connected daemons for the
specified compute profile - this must be set prior to calling this function.
Designed for performing setup operations across daemons by loading packages
or exporting common data. Resultant changes to the global environment, loaded
packages and options are persisted regardless of a daemon's \code{cleanup}
setting.
}
\details{
This function should be called when no other mirai operations are in
progress. If necessary, wait for all mirai operations to complete. This is as
this function does not force a synchronization point, and using concurrently
with other mirai operations does not guarantee the timing of when the
instructions will be received, or that they will be received on each daemon.
}
\section{Evaluation}{


The expression \code{.expr} will be evaluated in a separate R process in a clean
environment (not the global environment), consisting only of the objects
supplied to \code{.args}, with the objects passed as \code{...} assigned to the global
environment of that process.

As evaluation occurs in a clean environment, all undefined objects must be
supplied through \code{...} and/or \code{.args}, including self-defined functions.
Functions from a package should use namespaced calls such as
\code{mirai::mirai()}, or else the package should be loaded beforehand as part of
\code{.expr}.

For evaluation to occur \emph{as if} in your global environment, supply objects to
\code{...} rather than \code{.args}, e.g. for free variables or helper functions
defined in function bodies, as scoping rules may otherwise prevent them from
being found.
}

\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
daemons(1)
# export common data by a super-assignment expression:
everywhere(y <<- 3)
# '...' variables are assigned to the global environment
# '.expr' may be specified as an empty {} in such cases:
everywhere({}, a = 1, b = 2)
m <- mirai(a + b - y == 0L)
m[]
# everywhere() returns a list of mirai which may be waited for and inspected
mlist <- everywhere("just a normal operation")
collect_mirai(mlist)
mlist <- everywhere(stop("error"))
collect_mirai(mlist)
daemons(0)

# loading a package on all daemons
daemons(1, dispatcher = FALSE)
everywhere(library(parallel))
m <- mirai("package:parallel" \%in\% search())
m[]
daemons(0)
\dontshow{\}) # examplesIf}
}
