% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/key2binary.R
\name{key2binary}
\alias{key2binary}
\title{Score a test by converting response patterns to binary data}
\usage{
key2binary(fulldata, key)
}
\arguments{
\item{fulldata}{an object of class \code{data.frame}, \code{matrix}, or
\code{table} with the response patterns}

\item{key}{a vector or matrix consisting of the 'correct' response to the items. Each
value/row corresponds to each column in \code{fulldata}. If the input is a matrix, multiple
scoring keys can be supplied for each item. NA values are used to indicate no scoring key (or
in the case of a matrix input, no additional scoring keys)}
}
\value{
Returns a numeric matrix with all the response patterns in
  dichotomous format
}
\description{
The \code{key2binary} function will convert response pattern data to a
dichotomous format, given a response key.
}
\examples{

data(SAT12)
head(SAT12)
key <- c(1,4,5,2,3,1,2,1,3,1,2,4,2,1,5,3,4,4,1,4,3,3,4,1,3,5,1,3,1,5,4,5)

dicho.SAT12 <- key2binary(SAT12, key)
head(dicho.SAT12)

# multiple scoring keys
key2 <- cbind(c(1,4,5,2,3,1,2,1,3,1,2,4,2,1,5,3,4,4,1,4,3,3,4,1,3,5,1,3,1,5,4,5),
              c(2,3,NA,1,rep(NA, 28)))
dicho.SAT12 <- key2binary(SAT12, key2)

# keys from raw character responses
resp <- as.data.frame(matrix(c(
  "B","B","D","D","E",
  "B","A","D","D","E",
  "B","A","D","C","E",
  "D","D","D","C","E",
  "B","C","A","D","A"), ncol=5, byrow=TRUE))

key <- c("B", "D", "D", "C", "E")

d01 <- key2binary(resp, key)
head(d01)

}
\references{
Chalmers, R., P. (2012). mirt: A Multidimensional Item Response Theory
Package for the R Environment. \emph{Journal of Statistical Software, 48}(6), 1-29.
\doi{10.18637/jss.v048.i06}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
