% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.R
\name{gextract}
\alias{gextract}
\title{Returns evaluated track expression}
\usage{
gextract(
  ...,
  intervals = NULL,
  colnames = NULL,
  iterator = NULL,
  band = NULL,
  file = NULL,
  intervals.set.out = NULL
)
}
\arguments{
\item{...}{track expression}

\item{intervals}{genomic scope for which the function is applied}

\item{colnames}{sets the columns names in the returned value. If 'NULL'
names are set to track expression.}

\item{iterator}{track expression iterator. If 'NULL' iterator is determined
implicitly based on track expressions.}

\item{band}{track expression band. If 'NULL' no band is used.}

\item{file}{file name where the function result is optionally outputted in
tab-delimited format}

\item{intervals.set.out}{intervals set name where the function result is
optionally outputted}
}
\value{
If 'file' and 'intervals.set.out' are 'NULL' a set of intervals with
an additional column for each of the track expressions and 'columnID'
column.
}
\description{
Returns the result of track expressions evaluation for each of the iterator
intervals.
}
\details{
This function returns the result of track expressions evaluation for each of
the iterator intervals. The returned value is a set of intervals with an
additional column for each of the track expressions. This value can be used
as an input for any other function that accepts intervals. If the intervals
inside 'intervals' argument overlap gextract returns the overlapped
coordinate more than once.

The order inside the result might not be the same as the order of intervals.
An additional column 'intervalID' is added to the return value. Use this
column to refer to the index of the original interval from the supplied
'intervals'.

If 'file' parameter is not 'NULL' the result is outputted to a tab-delimited
text file (without 'intervalID' column) rather than returned to the user.
This can be especially useful when the result is too big to fit into the
physical memory.  The resulted file can be used as an input for
'gtrack.import' or 'gtrack.array.import' functions.

If 'intervals.set.out' is not 'NULL' the result is saved as an intervals
set. Similarly to 'file' parameter 'intervals.set.out' can be useful to
overcome the limits of the physical memory.

'colnames' parameter controls the names of the columns that contain the
evaluated expressions. By default the column names match the track
expressions.
}
\examples{
\dontshow{
options(gmax.processes = 2)
}

gdb.init_examples()

## get values of 'dense_track' for [0, 500), chrom 1
gextract("dense_track", gintervals(1, 0, 500))

## get values of 'rects_track' (a 2D track) for a 2D interval
gextract(
    "rects_track",
    gintervals.2d("chr1", 0, 4000, "chr2", 2000, 5000)
)

## get values of two track expressions 'dense_track' and
## 'array_track * 2' running over '100' iterator
gextract("dense_track", "array_track * 2", gintervals(1, 0, 500),
    iterator = 100, colnames = c("expr1", "expr2")
)

}
\seealso{
\code{\link{gtrack.array.extract}}, \code{\link{gsample}},
\code{\link{gtrack.import}}, \code{\link{gtrack.array.import}},
\code{\link{glookup}}, \code{\link{gpartition}}, \code{\link{gdist}}
}
\keyword{~extract}
