% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Trates.R
\name{Trates}
\alias{Trates}
\title{Threshold rates: a function for computing error rates and Matthews correlation coefficient of a specific LR threshold.}
\usage{
Trates(datasim, threshold)
}
\arguments{
\item{datasim}{Input dataframe containing expected LRs for related and unrelated POIs. It should be the output from makeLRsims function.}

\item{threshold}{Likelihood ratio threshold selected for error rates calculation.}
}
\value{
Values of false positive and false negative rates and MCC for a specific LR threshold.
}
\description{
Threshold rates: a function for computing error rates and Matthews correlation coefficient of a specific LR threshold.
}
\examples{
library(forrel)
x = linearPed(2)
x = setMarkers(x, locusAttributes = NorwegianFrequencies[1:5])
x = profileSim(x, N = 1, ids = 2)[[1]]
datasim = simLRgen(x, missing = 5, 10, 123)
Trates(datasim, 10)
}
