% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MAP.R
\name{MAP}
\alias{MAP}
\title{Missing data spike-in in MAP pattern}
\usage{
MAP(X_hat, MD_pattern, NA_fraction, min_PDM = 10,
  assumed_pattern = c("MAR", "MCAR", "MCAR", "MAR", "MNAR", "MCAR",
  "MCAR", "MAR", "MNAR", "MCAR", "MCAR"))
}
\arguments{
\item{X_hat}{Simulated matrix with no missingness (Simulated_matrix output from the \code{\link{simulate}} function)}

\item{MD_pattern}{Missing data pattern in the original dataset (MD_Pattern output from the \code{\link{get_data}} function)}

\item{NA_fraction}{Fraction of missingness in the original dataset (Fraction_missingness output from the \code{\link{get_data}} function)}

\item{min_PDM}{All patterns with number of observations less than this number will be removed from the missing data generation. This argument is necessary to be carefully set, as the function will fail or generate erroneous missing data patterns with very complicated missing data patterns. The default is 10, but for large datasets this number needs to be set higher to avoid errors. Please select a value based on the min_PDM_thresholds output from the \code{\link{get_data}} function}

\item{assumed_pattern}{Vector of missingness types (must be same length as missingness fraction per variable)}
}
\value{
\item{MAP_matrix}{Matrix with MAP pre-defined missingness pattern}
\item{Summary}{Summary of MAP_matrix including number of missing values per variable}
}
\description{
\code{\link{MAP}} spikes in missingness using missing-at-assumed (MAP) pattern
}
\details{
This function uses the generated simulated matrix and generates missing datapoints in a missing-at-assumed
pattern for each variable using the \code{\link[mice]{ampute}} function, considering the fraction of missingness in
the original dataset and the original missingness pattern. In the \code{\link{MAP}} function, the user needs to define a character vector
(of length the same as the fraction the number of columns in the dataset) that specifies which missingness pattern corresponds
to the variables. In case the first four columns are assumed missing at random, the next one missing completely at random and
the last two column not at random, the input vector will be:
\code{c(rep('MAR', 4), 'MCAR', rep('MNAR',2))}
The algorithm will spike in missing values according to the specified pattern. Please note that after the missing data spike-in,
the function will remove rows with 100\% missing data.
}
\examples{
cleaned <- clean(clindata_miss, missingness_coding = -9)
metadata <- get_data(cleaned)
simulated <- simulate(rownum = metadata$Rows, colnum = metadata$Columns,
cormat = metadata$Corr_matrix)

MAP(simulated$Simulated_matrix,
    MD_pattern = metadata$MD_Pattern,
    NA_fraction = metadata$Fraction_missingness,
    min_PDM = 10,
    assumed_pattern = c('MAR', 'MCAR', 'MCAR', 'MAR', 'MNAR', 'MCAR',
                        'MAR', 'MCAR', 'MCAR', 'MAR', 'MNAR'))

}
