% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Class-missSBM_collection.R
\name{smooth}
\alias{smooth}
\title{Smooth the path ICL in a collection of missSBM_fit models}
\usage{
smooth(Robject, type = c("forward", "backward", "both"), control = list())
}
\arguments{
\item{Robject}{an object with class missSBM_collection, i.e. an output from \code{\link[=estimateMissSBM]{estimateMissSBM()}}}

\item{type}{character indicating what kind of ICL smoothing should be use among "forward", "backward" or "both". Default is "forward".}

\item{control}{a list controlling the variational EM algorithm. See details.}
}
\value{
An invisible missSBM_collection, in which the ICL has been smoothed
}
\description{
Apply a split and/or merge strategy of the clustering in a path of models in a collection
of SBM ordered by number of block. The goal is to find better initialization. This results
in a "smoothing" of the ICL, that should be close to concave.
}
\details{
The list of parameters \code{control} controls the optimization process and the variational EM algorithm, with the following entries
\itemize{
\item{"iterates": }{integer for the number of iterations of smoothing. Default is 1.}
\item{"threshold": }{V-EM algorithm stops stop when an optimization step changes the objective function
by less than threshold. Default is 1e-3.}
\item{"maxIter": }{V-EM algorithm stops when the number of iteration exceeds maxIter.
Default is 100 with no covariate, 50 otherwise.}
\item{"fixPointIter": }{number of fix-point iterations in the V-E step.
Default is 5 with no covariate, 2 otherwise.}
\item{"cores": }{integer for number of cores used. Default is 1.}
\item{"trace": }{integer for verbosity. Useless when \code{cores} > 1}
}
}
