% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trafo.R
\name{trafo}
\alias{trafo}
\title{Modifications of Transformations}
\usage{
trafo(O, type = "new", trans, invtrans, print, deriv, operation,
  value = 0)
}
\arguments{
\item{O}{distribution object.}

\item{type}{type of modification to be performed, default: 'new'.}

\item{trans}{transformation expression.}

\item{invtrans}{inverse transformation expression.}

\item{print}{print expression.}

\item{deriv}{derivative expression.}

\item{operation}{string indicating which operation is performed.}

\item{value}{numeric value used in operation, default: 0.}
}
\value{
Transformed distribution object.
}
\description{
The function modifies the given object and adds the transformation expressions.
}
\details{
\code{trafo} is the main function used in the transformation framework. The function
         offers four types of possible modifications. Note, that all expressions must use X to indicate the object in the transformation.
         
         \strong{type = "init"}: Initializes the needed lists for transformations and adds the first expressions.
         This type should be used only with yet untransformed distributions as the first modification. All arguments must be set.
         
         \strong{type = "new"}: Adds a new transformation to the current ones. 
         This must be used only on already transformed distributions. All arguments must be set.
         
         \strong{type = "update"}: Updates previous expression. This is useful when same transformation is used twice in a row.
         All arguments except operation must be set.
         
         \strong{type = "go_back"}: Uses to history to reverse the previous transformation. 
         Useful if inverse of previous transformation is evaluated. Only object and type must be specified.
}
\examples{
#init
P <- poisdist(5) ; x <- 5
P2 <- trafo(P, type = "init", trans = bquote(X + .(x)),
            invtrans = bquote(X - .(x)), print = bquote(X + .(x)),
            deriv = quote(1), operation = "+", value = x)
P2

#new
x = 3
P3 <- trafo(P2, type = "new", trans = bquote(.(x) * X),
            invtrans = bquote(X/.(x)), print = bquote(.(x) * X),
            deriv = bquote(1/.(x)), operation = "*", value = x)
P3

#update
x = 7 
P4 <- trafo(P3, type = "update", trans = bquote(.(x) * X),
            invtrans = bquote(X/.(x)), print = bquote(.(x) * X),
            deriv = bquote(1/.(x)), value = x)
P4

#go_back
P5 <- trafo(P4, type = "go_back")
P5
}
