% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trafo.R
\name{Distribution_transformation}
\alias{Distribution_transformation}
\alias{+.univdist}
\alias{+.trans_univdist}
\alias{*.univdist}
\alias{*.trans_univdist}
\alias{/.dist}
\alias{-.dist}
\alias{sqrt.dist}
\alias{log.univdist}
\alias{log.trans_univdist}
\alias{exp.univdist}
\alias{exp.trans_univdist}
\alias{^.univdist}
\alias{^.trans_univdist}
\alias{+.normdist}
\alias{*.normdist}
\alias{exp.normdist}
\alias{*.expdist}
\alias{^.expdist}
\alias{+.unifdist}
\alias{*.unifdist}
\alias{^.tdist}
\alias{^.fdist}
\alias{-.betadist}
\alias{-.binomdist}
\alias{*.gammadist}
\alias{+.cauchydist}
\alias{*.cauchydist}
\alias{^.cauchydist}
\alias{*.lnormdist}
\alias{log.lnormdist}
\alias{^.lnormdist}
\alias{*.weibulldist}
\alias{+.gumbeldist}
\alias{*.gumbeldist}
\alias{+.frechetdist}
\alias{*.frechetdist}
\alias{*.paretodist}
\alias{+.GPDdist}
\alias{*.GPDdist}
\title{Transformation of a Distribution Object}
\usage{
\method{+}{univdist}(e1, e2 = NULL)

\method{+}{trans_univdist}(e1, e2 = NULL)

\method{*}{univdist}(e1, e2)

\method{*}{trans_univdist}(e1, e2)

\method{/}{dist}(e1, e2)

\method{-}{dist}(e1, e2 = NULL)

\method{sqrt}{dist}(x)

\method{log}{univdist}(x, base = exp(1))

\method{log}{trans_univdist}(x, base = exp(1))

\method{exp}{univdist}(x)

\method{exp}{trans_univdist}(x)

\method{^}{univdist}(e1, e2)

\method{^}{trans_univdist}(e1, e2)

\method{+}{normdist}(e1, e2)

\method{*}{normdist}(e1, e2)

\method{exp}{normdist}(x)

\method{*}{expdist}(e1, e2)

\method{^}{expdist}(e1, e2)

\method{+}{unifdist}(e1, e2)

\method{*}{unifdist}(e1, e2)

\method{^}{tdist}(e1, e2)

\method{^}{fdist}(e1, e2)

\method{-}{betadist}(e1, e2 = NULL)

\method{-}{binomdist}(e1, e2 = NULL)

\method{*}{gammadist}(e1, e2)

\method{+}{cauchydist}(e1, e2)

\method{*}{cauchydist}(e1, e2)

\method{^}{cauchydist}(e1, e2)

\method{*}{lnormdist}(e1, e2)

\method{log}{lnormdist}(x, base = exp(1))

\method{^}{lnormdist}(e1, e2)

\method{*}{weibulldist}(e1, e2)

\method{+}{gumbeldist}(e1, e2)

\method{*}{gumbeldist}(e1, e2)

\method{+}{frechetdist}(e1, e2)

\method{*}{frechetdist}(e1, e2)

\method{*}{paretodist}(e1, e2)

\method{+}{GPDdist}(e1, e2)

\method{*}{GPDdist}(e1, e2)
}
\arguments{
\item{e1}{distribution object or numeric of length one.}

\item{e2}{distribution object or numeric of length one.}

\item{x}{distribution object.}

\item{base}{a positive number: the base with respect to which logarithms are computed.}
}
\value{
Object representing a transformed random variable.
}
\description{
The methods for arithmetic operators \code{+, -, *, /, ^, log, exp, sqrt}, which perform
             a transformation of a given random variable.
}
\details{
The offered arithmetic operators \code{+, -, *, /, ^, log, exp, sqrt} create
         an object that represents transformed random variable.

         The functions, using the expressions manipulation, prepare expressions for
         transformation, inverse transformation, derivative of the inverse transformation
         and print. These expressions are then used later when the distribution is evaluated.

         The transformation framework also keeps track on history of the transformations and so
         is able to recognize some inverse transformations of previous transformations or update
         the last transformation.
         Additionally, the methods are able to recognize some invariant and direct transformations,
         and so rather change the parameters or distribution family than to loose this
         information.
}
\examples{
# transformation
B  <- binomdist(10, 0.3)
B2 <- - 3*log(B)
B2

# invariant transformation
N  <- normdist(1, 3)
N2 <- - 3*N + 5
N2

# direct transformation
N3 <- exp(N2)
N3

# recognize inverse
B3 <- exp(B2/-3)
B3
# update
B4 <- B + 5
B4 + 3

}
