% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/standist.R
\name{q_approxfun}
\alias{q_approxfun}
\alias{q_approxfun.dist}
\title{Quantile Function Approximation}
\usage{
q_approxfun(O, range = q(O, c(0.005, 0.995)), n = 1000)

\method{q_approxfun}{dist}(O, range = q(O, c(0.005, 0.995)), n = 1000)
}
\arguments{
\item{O}{distribution object.}

\item{range}{interval on which the grid is defined, q(O, c(0.005, 0.995)).}

\item{n}{number of points within the grid, default: 1000.}
}
\value{
Function.
}
\description{
\code{q_approxfun} is a generic function that for a given object generates function to approximate the quantile function.
}
\details{
Function \code{q_approxfun} generates a grid of values on which the CDF of the object is evaluated.
         The function returns a quantile function that uses \code{\link[stats]{approx}} and the values 
         of the grid to approximate the quantiles. This function is designed mostly for the mixture distributions
         where the standard \code{q} method may be slow and thus allows to trade the accuracy for the speed. 
         
         The returned function takes the arguments \code{p}, \code{lower.tail} and \code{log.p}, see \code{\link{q}}.
}
\examples{
N <- normdist(1, 3)
N2 <- normdist(8, 3)

M <- mixdist(N, N2, weights = c(0.5, 0.5))
q_app <- q_approxfun(M)

q_app(c(.2, .5, .7))
q_app(c(.2, .5, .7), lower.tail = FALSE)
}
