% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.square.matrix.R
\name{print.square.matrix}
\alias{print.square.matrix}
\title{Print square.matrix object}
\usage{
\method{print}{square.matrix}(x, tri = x$args$tri, digits = x$args$digits,
         check = TRUE, ...)
}
\arguments{
\item{x}{\code{square.matrix} object.}

\item{tri}{a character string or character vector indicating which triangular of the matrix
to show on the console, i.e., \code{both} for upper and lower triangular,
\code{lower} for the lower triangular, and \code{upper} for the upper
triangular.}

\item{digits}{an integer value indicating the number of decimal places digits to be used for
displaying results.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{...}{further arguments passed to or from other methods.}
}
\description{
This function prints the \code{square.matrix} object
}
\examples{
#------------------------------------
# Pearson's Contingency Coefficient
dat <- data.frame(x = c(1, 1, 2, 1, 3, 3, 2, 2, 1, 2),
                  y = c(3, 2, 3, 1, 2, 4, 1, 2, 3, 4),
                  z = c(2, 2, 2, 1, 2, 2, 1, 2, 1, 2), stringsAsFactors = FALSE)

# Adjusted Contingency coefficient between x and y
dat.cont <- cont.coef(dat[, c("x", "y")], output = FALSE)

# Print cont.coef object with 5 digits
print(dat.cont, digits = 5)

#------------------------------------
# Cramer's V
dat <- data.frame(x = c(1, 1, 2, 1, 3, 3, 2, 2, 1, 2),
                  y = c(1, 2, 2, 1, 3, 4, 1, 2, 3, 1),
                  z = c(1, 1, 2, 1, 2, 3, 1, 2, 3, 2),
                  stringsAsFactors = FALSE)

# Bias-corrected Cramer's V between x and y
dat.cramer <- cramers.v(dat[, c("x", "y")], output = FALSE)

# Print cramers.v object with 4 digits
print(dat.cramer, digits = 4)

#------------------------------------
# Auxiliary variables analysis
dat <- data.frame(x1 = c(1, NA, 2, 5, 3, NA, 5, 2),
                  x2 = c(4, 2, 5, 1, 5, 3, 4, 5),
                  x3 = c(NA, 3, 2, 4, 5, 6, NA, 2),
                  x4 = c(5, 6, 3, NA, NA, 4, 6, NA),
                  stringsAsFactors = FALSE)

# Auxiliary variables
dat.na.auxiliary <- na.auxiliary(dat, output = FALSE)

# Print na.auxiliary object with 3 digits
print(dat.na.auxiliary, digits = 3)

#------------------------------------
# Variance-Covariance Coverage
dat <- data.frame(x = c(1, NA, NA, 6, 3),
                  y = c(7, NA, 8, 9, NA),
                  z = c(2, NA, 3, NA, 5),
                  stringsAsFactors = FALSE)

# Create missing data indicator matrix R
na.coverage(dat)

# Create missing data indicator matrix R
dat.coverage <- na.coverage(dat, output = FALSE)

# Print na.coverage object with 5 digits
print(dat.coverage, digits = 5)

#------------------------------------
# Phi Coefficient
dat <- data.frame(x1 = c(0, 1, 0, 1, 0, 1, 0, 1, 1, 0),
                  x2 = c(0, 1, 0, 0, 1, 1, 1, 1, 1, 1),
                  x3 = c(0, 1, 0, 1, 1, 1, 1, 1, 0, 0),
                  stringsAsFactors = FALSE)

# Ajusted phi coefficient between x1 and x2
dat.phi <- phi.coef(dat[, c("x1", "x2")], output = FALSE)

# Print phi.coef object with 5 digits
print(dat.phi, digits = 5)

# Polychoric Correlation Matrix
dat <- data.frame(x1 = c(1, 1, 3, 2, 1, 2, 3, 2, 3, 1),
                  x2 = c(1, 2, 1, 1, 2, 2, 2, 1, 3, 1),
                  x3 = c(1, 3, 2, 3, 3, 1, 3, 2, 1, 2), stringsAsFactors = FALSE)

# Polychoric correlation matrix
dat.poly <- poly.cor(dat, output = FALSE)

# Print poly.cor object with 3 digits
print(dat.poly, digits = 3)
}
\seealso{
\code{\link{cont.coef}},\code{\link{cramers.v}}, \code{\link{na.auxiliary}}, \code{\link{na.coverage}},
\code{\link{phi.coef}}, \code{\link{poly.cor}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
