% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test.welch.R
\name{test.welch}
\alias{test.welch}
\title{Welch's Test}
\usage{
test.welch(formula, data, alternative = c("two.sided", "less", "greater"),
           conf.level = 0.95, hypo = TRUE, descript = TRUE, effsize = FALSE,
           weighted = FALSE, ref = NULL, correct = FALSE, digits = 2,
           p.digits = 4, as.na = NULL, check = TRUE, output = TRUE, ...)
}
\arguments{
\item{formula}{a formula of the form \code{y ~ group} where \code{y} is a numeric variable
giving the data values and \code{group} a numeric variable, character variable
or factor with two or more than two values or factor levels giving the
corresponding groups.}

\item{data}{a matrix or data frame containing the variables in the formula \code{formula}.}

\item{alternative}{a character string specifying the alternative hypothesis, must be one of
code{"two.sided"} (default), \code{"greater"} or \code{"less"}. Note that this
argument is only used when conducting Welch's two-sample t-test.}

\item{conf.level}{a numeric value between 0 and 1 indicating the confidence level of the interval
for Cohen's d.
Note that this argument is only used when conducting Welch's two-sample t-test.}

\item{hypo}{logical: if \code{TRUE}, null and alternative hypothesis are shown on the console.}

\item{descript}{logical: if \code{TRUE}, descriptive statistics are shown on the console.}

\item{effsize}{logical: if \code{TRUE}, effect size measure Cohen's d for Welch's two-sample t-test
(see \code{\link{cohens.d}}), \eqn{\eta^2} and \eqn{\omega^2} for Welch's ANOVA are
shown on the console.}

\item{weighted}{logical: if \code{TRUE}, the weighted pooled standard deviation is used to compute Cohen's d.}

\item{ref}{a numeric value or character string indicating the reference group. The standard
deviation of the reference group is used to standardized the mean difference to compute Cohen's d.}

\item{correct}{logical: if \code{TRUE}, correction factor to remove positive bias in small samples is used.}

\item{digits}{an integer value indicating the number of decimal places to be used for displaying
descriptive statistics and confidence interval.}

\item{p.digits}{an integer value indicating the number of decimal places to be used for displaying
the \emph{p}-value.}

\item{as.na}{a numeric vector indicating user-defined missing values,
i.e. these values are converted to \code{NA} before conducting the analysis.}

\item{check}{logical: if \code{TRUE}, argument specification is checked.}

\item{output}{logical: if \code{TRUE}, output is shown on the console.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
Returns an object of class \code{misty.object}, which is a list with following entries:
function call (\code{call}), type of analysis \code{type}, list with the input specified in \code{x}
(\code{data}), specification of function arguments (\code{args}), and result table(s) (\code{result}).
}
\description{
This function performs Welch's two-sample t-test and Welch's ANOVA.
}
\details{
Note that by default Welch's two-sample t-test reports Cohen's d based on the unweighted
standard deviation (i.e., \code{weighted = FALSE}) when requesting an effect size measure
(i.e., \code{effsize = TRUE}) following the recommendation by Delacre et al. (2021).
}
\examples{
dat1 <- data.frame(group1 = c(1, 1, 1, 1, 1, 1, 2, 2, 2, 2, 2, 2),
                   group2 = c(1, 1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 3),
                   x = c(3, 1, 4, 2, 5, 3, 2, 3, 6, 6, 3, NA))

#--------------------------------------
# Two-Sample Design

# Two-sided two-sample Welch-test
test.welch(x ~ group1, data = dat1)

# One-sided two-sample Welch-test
test.welch(x ~ group1, data = dat1, alternative = "greater")

# Two-sided two-sample Welch-test
# print Cohen's d with weighted pooled SD
test.welch(x ~ group1, data = dat1, effsize = TRUE)

# Two-sided two-sample Welch-test
# print Cohen's d with unweighted pooled SD
test.welch(x ~ group1, data = dat1, effsize = TRUE, weighted = FALSE)

# Two-sided two-sample Welch-test
# print Cohen's d with weighted pooled SD and
# small sample correction factor
test.welch(x ~ group1, data = dat1, effsize = TRUE, correct = TRUE)

# Two-sided two-sample Welch-test
# print Cohen's d with SD of the reference group 1
test.welch(x ~ group1, data = dat1, effsize = TRUE,
           ref = 1)

# Two-sided two-sample Welch-test
# print Cohen's d with weighted pooled SD and
# small sample correction factor
test.welch(x ~ group1, data = dat1, effsize = TRUE,
           correct = TRUE)

# Two-sided two-sample Welch-test
# do not print hypotheses and descriptive statistics,
test.welch(x ~ group1, data = dat1, descript = FALSE, hypo = FALSE)

# Two-sided two-sample Welch-test
# print descriptive statistics with 3 digits and p-value with 5 digits
test.welch(x ~ group1, data = dat1, digits = 3, p.digits = 5)

#--------------------------------------
# Multiple-Sample Design

# Welch's ANOVA
test.welch(x ~ group2, data = dat1)

# Welch's ANOVA
# print eta-squared and omega-squared
test.welch(x ~ group2, data = dat1, effsize = TRUE)

# Welch's ANOVA
# do not print hypotheses and descriptive statistics,
test.welch(x ~ group2, data = dat1, descript = FALSE, hypo = FALSE)
}
\references{
Rasch, D., Kubinger, K. D., & Yanagida, T. (2011). \emph{Statistics in psychology - Using R and SPSS}.
John Wiley & Sons.

Delacre, M., Lakens, D., Ley, C., Liu, L., & Leys, C. (2021). Why Hedges' g*s based on the non-pooled
standard deviation should be reported with Welch's t-test. https://doi.org/10.31234/osf.io/tu6mp
}
\seealso{
\code{\link{test.t}}, \code{\link{test.z}}, \code{\link{test.levene}}, \code{\link{cohens.d}},
\code{\link{ci.mean.diff}}, \code{\link{ci.mean}}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at}
}
